<?php

error_reporting(E_ALL);
set_include_path('/home/mpsv2gunwebsyste/public_html/gws/');
require 'vendor/PHPExcel/PHPExcel.php';

$ftp_server_dir = "/public_ftp/promoproductsexcels/";
$local_dir = __DIR__ . '/excels';
$remote_ftp_location_configs = array('ftp_server' => '221.121.145.119', 'ftp_user' => 'mpsv2gunwebsyste', 'ftp_password' => 'ymNUpK.9*,[A2]9[');


/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Supplier
{

	public $supsno;
	public $supsup_fref;
	public $ftpAutoProductUploadEnable;

}

class Category
{

	public $id;
	public $name;
	public $description;

}

class Subcategory
{

	public $id;
	public $productCategoryId;
	public $name;
	public $description;

}

class Product
{

	public $pdlsno;
	public $pdlprdsno;
	public $pdlprdline;
	public $pdlpdl;
	public $pdldes;
	public $pdlimage1;
	public $pdlsupsno;
	public $pdluntprice;
	public $sellingPrice;
	public $categoryId;
	public $subCategoryId;
	public $qty_on_hand;
	public $qty_available;

}

class ProductPrice
{

	public $pdpsno;
	public $pdppdlsno;
	public $pdpquantity_break_level;
	public $pdpsquantity;
	public $pdpprice;
	public $pdpsellprice;

}

function getDBConnection()
{
	$servername = "localhost";
	$username = "mpsv2gun_qcav2";
	$password = "]cuy*x&cU2jk";
	$dbname = "mpsv2gun_mpvs2";

	// Create connection
	$conn = new mysqli($servername, $username, $password, $dbname);
	// Check connection
	if ($conn->connect_error) {
		die("Connection failed: " . $conn->connect_error);
	}

	return $conn;
}

/*
 * Get uploaded product excel name list
 */

function getProductExcelLookupList($dbConnection)
{
	$sql = "SELECT id, file_name FROM product_excel_lookup";
	$result = $dbConnection->query($sql);
	if ($result->num_rows > 0) {
		$filesArr = array();
		while ($row = $result->fetch_assoc()) {
			$filesArr[$row["id"]] = $row["file_name"];
		}

		return $filesArr;
	}

	return null;
}

function getProductExcel($dbConnection, $fileName)
{
	$sql = "SELECT id, file_name FROM product_excel_lookup WHERE  file_name = '$fileName' LIMIT 1";
	$result = $dbConnection->query($sql);

	if ($followingdata = $result->fetch_assoc()) {
		return array(
			$followingdata["id"] => $followingdata["file_name"]
		);
	}



	return null;
}

/*
 * @return Supplier object
 */

function getSupplierByCode($dbConnection, $supplierCode)
{

	if (trim($supplierCode)) {
		$stmt = $dbConnection->prepare('SELECT supsno, supsup_fref, ftpAutoProductUploadEnable FROM supplier WHERE supsup_fref = ?');
		$s = $supplierCode;
		$stmt->bind_param('s', $s); // 's' specifies the variable type => 'string'

		$stmt->execute();
		$result = $stmt->get_result();
		if ($result->num_rows > 0) {
			$row = mysqli_fetch_assoc($result);
			$supplier = new Supplier();
			$supplier->supsno = $row['supsno'];
			$supplier->supsup_fref = $row['supsup_fref'];
			$supplier->ftpAutoProductUploadEnable = $row['ftpAutoProductUploadEnable'];

			$stmt->close();
			return $supplier;
		}
		$stmt->close();
	}
	return null;
}

/*
 * @return Category object
 */

function getCategory($dbConnection, $categoryName)
{
	if (trim($categoryName)) {
		$stmt = $dbConnection->prepare('SELECT id, name, description FROM product_category WHERE name = ?');
		$stmt->bind_param('s', $categoryName); // 's' specifies the variable type => 'string'

		$stmt->execute();
		$result = $stmt->get_result();
		if ($result->num_rows > 0) {
			$row = mysqli_fetch_assoc($result);
			$category = new Category();
			$category->id = $row['id'];
			$category->name = $row['name'];
			$category->description = $row['description'];

			$stmt->close();
			return $category;
		}
		$stmt->close();
	}
	return null;
}

/*
 * @return Category object
 */

function createCategory($dbConnection, $categoryName)
{
	if (trim($categoryName)) {
		$stmt = $dbConnection->prepare('INSERT INTO product_category (name, description, createdDate) VALUES (?, ?, ?)');
		$createdDate = date('Y-m-d');
		$stmt->bind_param('sss', $categoryName, $categoryName, $createdDate); // 's' specifies the variable type => 'string'

		if ($stmt->execute()) {
			$stmt->close();
			return getCategory($dbConnection, $categoryName);
		}
		$stmt->close();
	}
	return null;
}

/*
 * @return Subcategory object
 */

function getSubcategory($dbConnection, Category $category, $subcategoryName)
{
	if ($category && trim($subcategoryName)) {
		$stmt = $dbConnection->prepare('SELECT id, productCategoryId, name, description FROM product_sub_category WHERE productCategoryId = ? AND name = ?');
		$stmt->bind_param('is', $category->id, $subcategoryName); // 's' specifies the variable type => 'string', 'i' specifies the variable type => 'integer'

		$stmt->execute();
		$result = $stmt->get_result();
		if ($result->num_rows > 0) {
			$row = mysqli_fetch_assoc($result);
			$subcategory = new Subcategory();
			$subcategory->id = $row['id'];
			$subcategory->productCategoryId = $row['productCategoryId'];
			$subcategory->name = $row['name'];
			$subcategory->description = $row['description'];

			$stmt->close();
			return $subcategory;
		}
		$stmt->close();
	}
	return null;
}

/*
 * @return Subcategory object
 */

function createSubcategory($dbConnection, Category $category, $subcategoryName)
{
	if ($category && trim($subcategoryName)) {
		$stmt = $dbConnection->prepare('INSERT INTO product_sub_category (productCategoryId, name, description, createdDate) VALUES (?, ?, ?, ?)');
		$createdDate = date('Y-m-d');
		$catId = $category->id;
		$stmt->bind_param('isss', $catId, $subcategoryName, $subcategoryName, $createdDate); // 's' specifies the variable type => 'string', 'i' specifies the variable type => 'integer'

		if ($stmt->execute()) {
			$stmt->close();
			return getSubcategory($dbConnection, $category, $subcategoryName);
		}
		$stmt->close();
	}
	return null;
}

/*
 * @return Product object
 */

function getProduct($dbConnection, $code)
{
	if (trim($code)) {
		$stmt = $dbConnection->prepare('SELECT pdlsno, pdlprdsno, pdlprdline, pdlpdl, pdldes, pdlimage1, pdlsupsno, pdluntprice, sellingPrice, categoryId, subCategoryId, qty_on_hand, qty_available FROM product_line WHERE pdlpdl = ?');
		$c = $code;
		$stmt->bind_param('s', $c); // 's' specifies the variable type => 'string', 'i' specifies the variable type => 'integer'

		$stmt->execute();
		$result = $stmt->get_result();
		if ($result->num_rows > 0) {
			$row = mysqli_fetch_assoc($result);
			$product = new Product();
			$product->pdlsno = $row['pdlsno'];
			$product->pdlprdsno = $row['pdlprdsno'];
			$product->pdlprdline = $row['pdlprdline'];
			$product->pdlpdl = $row['pdlpdl'];
			$product->pdldes = $row['pdldes'];
			$product->pdlimage1 = $row['pdlimage1'];
			$product->pdlsupsno = $row['pdlsupsno'];
			$product->pdluntprice = $row['pdluntprice'];
			$product->categoryId = $row['categoryId'];
			$product->subCategoryId = $row['subCategoryId'];
			$product->qty_on_hand = $row['qty_on_hand'];
			$product->qty_available = $row['qty_available'];

			$stmt->close();

			return $product;
		}
		$stmt->close();
	}
	return null;
}

/*
 * @return Subcategory object
 */

function createProduct($dbConnection, Product $product)
{
	$stmt = $dbConnection->prepare('INSERT INTO product_line (pdlprdline, pdlpdl, pdldes, pdlimage1, pdlsupsno, pdluntprice, sellingPrice, categoryId, subCategoryId, qty_on_hand, qty_available, pdlentddt, pdlenttime) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
	$createdDate = date('Y-m-d');
	$createdTime = date('H:i:s');
	$stmt->bind_param(
			'ssssiddiiiiss', $product->pdlprdline, $product->pdlpdl, $product->pdldes, $product->pdlimage1, $product->pdlsupsno, $product->pdluntprice, $product->sellingPrice, $product->categoryId, $product->subCategoryId, $product->qty_on_hand, $product->qty_available, $createdDate, $createdTime
	);
	// 's' specifies the variable type => 'string', 'i' specifies the variable type => 'integer', 'd' specifies the variable type => 'double'

	if ($stmt->execute()) {
		$stmt->close();
		return getProduct($dbConnection, $product->pdlpdl);
	}

	$stmt->close();
	return null;
}

function createProductPrice($dbConnection, array $price)
{
	if ($price['qty_from'] && $price['qty_to']) {
		$qty_to = ($price['qty_to'] > 0 ? $price['qty_to'] : 9999999999);
		$pp = new ProductPrice();
		$pp->pdppdlsno = $price['pdlsno'];
		$pp->pdpquantity_break_level = $price['pdpquantity_break_level'];
		$pp->pdpquantity = $price['qty_from'];
		$pp->pdpsquantity = $qty_to;

		$pricerounded = sprintf("%.2f", $price['pdpprice']);
		$pp->pdpprice = $pricerounded;

		$stmt = $dbConnection->prepare('INSERT INTO product_price (pdppdlsno, pdpquantity_break_level, pdpquantity, pdpsquantity, pdpprice, pdpentddt, pdpenttime) VALUES (?, ?, ?, ?, ?, ?, ?)');
		$createdDate = date('Y-m-d');
		$createdTime = date('H:i:s');
		$stmt->bind_param(
				'iiiidss', $pp->pdppdlsno, $pp->pdpquantity_break_level, $pp->pdpquantity, $pp->pdpsquantity, $pp->pdpprice, $createdDate, $createdTime
		);
		// 's' specifies the variable type => 'string', 'i' specifies the variable type => 'integer', 'd' specifies the variable type => 'double'

		$done = $stmt->execute();
		$stmt->close();
		return $done;
	}

	return false;
}

function createProductExcelLookupDetail($dbConnection, $excelLookupId, $productId)
{
	if ($excelLookupId && $productId) {


		$stmt = $dbConnection->prepare('INSERT INTO product_excel_lookup_details (product_excel_lookup_id, pdlsno) VALUES (?, ?)');

		$stmt->bind_param(
				'ii', $excelLookupId, $productId
		);
		// 's' specifies the variable type => 'string', 'i' specifies the variable type => 'integer', 'd' specifies the variable type => 'double'

		$done = $stmt->execute();
		$stmt->close();
		return $done;
	}

	return false;
}

/*
 * Delete all price quantity breaks related to the given product
 */

function deleteProductPrices($dbConnection, Product $product)
{

	$stmt = $dbConnection->prepare('DELETE FROM product_price WHERE pdppdlsno = ?');
	$stmt->bind_param(
			's', $product->pdlsno
	);
	// 's' specifies the variable type => 'string', 'i' specifies the variable type => 'integer', 'd' specifies the variable type => 'double'

	if ($stmt->execute()) {
		return true;
	}

	return false;
}

/*
 * Insert saved product excel file name
 */

function insertProductExcelLookupList($dbConnection, $fileName, $toBeRead, $logMessage)
{
	if ($fileName = trim($fileName)) {
		$sql = "INSERT INTO product_excel_lookup (file_name, created_date, to_be_read, log_message ) "
				. "VALUES ('{$fileName}', NOW(), {$toBeRead}, '{$logMessage}')";


		return $dbConnection->query($sql);
	}



	return false;
}

/*
 * Update saved product excel file name
 */

function updateProductExcelLookupList($dbConnection, $fileName, $toBeRead, $logMessage)
{
	if ($fileName = trim($fileName)) {
		$sql = "UPDATE product_excel_lookup SET to_be_read = {$toBeRead}, log_message = '{$logMessage}' WHERE file_name = '{$fileName}'";


		return $dbConnection->query($sql);
	}



	return false;
}

function getFtpConnection($ftp_config = array())
{
	//remote server
	$ftp_conn = ftp_connect($ftp_config['ftp_server']);

	ftp_login($ftp_conn, $ftp_config['ftp_user'], $ftp_config['ftp_password']);

	ftp_pasv($ftp_conn, true);

	return $ftp_conn;
}

function getRemoteFileList($ftp_conn, $ftp_server_dir = "/public_ftp/", $file_extensions = array('xls'))
{
    
    

// get file list of current directory
	$file_list = ftp_nlist($ftp_conn, $ftp_server_dir);
	



	$request_file_list = array();
	foreach ($file_list as $file_name) {

		$file_parts = pathinfo($file_name);
		if (isset($file_parts['extension']) && in_array($file_parts['extension'], $file_extensions)) {

			$request_file_list[] = basename($file_name);
		}
	}

	return $request_file_list;
}

function filterRemoteFilesLocal($remoteFiles, $localFiles = array())
{
	return $localFiles ? array_diff($remoteFiles, $localFiles) : $remoteFiles;
}

/*
 * 
 * Save remote excel files in local and return file name list
 * @return array file list
 */

function saveRemoteFilesInLocal($ftp_conn, $dbConnection, $ftp_server_dir, $local_dir, $file_list)
{
	if (!file_exists($local_dir)) {
		@mkdir($local_dir, 0755);
	}
	$savedFileList = array();
	foreach ($file_list as $key => $file_name) {

		$server_file = $ftp_server_dir . $file_name;
		$local_file = fopen($local_dir . '/' . $file_name, 'w+');
		if (ftp_fget($ftp_conn, $local_file, $server_file, FTP_BINARY)) {

			//if (updateProductExcelLookupList($dbConnection, $file_name)) {
			$savedFileList[] = $file_name;
			//}
			//$objReader = new PHPExcel_Reader_Excel5();
			//echo 'PHP excel object creted <br />';
			//$data = $objReader->load($local_dir . '/' . $file_name);
			//echo 'load excel from temp file <br />';
		}
	}

	return $savedFileList;
}

function getProductSupplierCode($file)
{
	$objReader = new PHPExcel_Reader_Excel5();
	$data = $objReader->load($file);
	$objWorksheet = $data->getActiveSheet();
	$highestRow = $objWorksheet->getHighestRow();
	for ($i = 1; $i <= $highestRow; $i++) {
		$suplierCode = $objWorksheet->getCellByColumnAndRow(0, $i)->getValue();
		if (!in_array(strtolower($suplierCode), array('supplier', 'sup', 'suplier', 'supplier_name', 'no_supplier'))) {
			return $suplierCode;
		}
	}

	return '';
}

/* Validate excel file
 * @return array of errors if available
 */

function validateFile($file)
{
	$errors = array();
	try {

		$objReader = new PHPExcel_Reader_Excel5();
		$data = $objReader->load($file);
		$objWorksheet = $data->getActiveSheet();
		$highestRow = $objWorksheet->getHighestRow();



		for ($i = 2; $i <= $highestRow; $i++) {



			$itemCode = trim($objWorksheet->getCellByColumnAndRow(2, $i)->getValue());
			$itemName = trim($objWorksheet->getCellByColumnAndRow(3, $i)->getValue());
			$itemDescription = trim($objWorksheet->getCellByColumnAndRow(4, $i)->getValue());

			$categoryName = trim($objWorksheet->getCellByColumnAndRow(24, $i)->getValue());
			//$subcategoryName = $objWorksheet->getCellByColumnAndRow(24, $i)->getValue();
			//$unitCost = $objWorksheet->getCellByColumnAndRow(6, $i)->getValue();
			//$sellingPrice = $objWorksheet->getCellByColumnAndRow(7, $i)->getValue();
			//$qtyOnHand = $objWorksheet->getCellByColumnAndRow(8, $i)->getValue();
			//$qtyAvailable = $objWorksheet->getCellByColumnAndRow(9, $i)->getValue();
			$imageName = trim($objWorksheet->getCellByColumnAndRow(28, $i)->getValue());

			if (!$itemCode) {
				$errors[] = "Item code was not found! [Line:$i]";
			}

			if (ctype_digit($itemCode)) {
				$errors[] = "Item code [$itemCode] is not valid! [Line:$i]";
			}

			if (!$itemName) {
				$errors[] = "Item name [$itemName] is not valid! [Line:$i]";
			}

			if (ctype_digit($itemName)) {
				$errors[] = "Item name [$itemName] is not valid! [Line:$i]";
			}

			if (!$itemDescription) {
				$errors[] = "Item description [$itemDescription] is not valid! [Line:$i]";
			}

			if (ctype_digit($itemDescription)) {
				$errors[] = "Item description [$itemDescription] is not valid! [Line:$i]";
			}

			if (ctype_digit($imageName)) {
				$errors[] = "Image name [$imageName] is not valid! [Line:$i]";
			}
		}
	} catch (Exception $e) {
		$errors[] = $e->getMessage();
	}

	return $errors;
}

/*
 * @return array of errors if available
 */

function uploadProducts($dbConnection, $file, Supplier $supplier, $excelLookupId)
{
	$errors = array();
	try {

		$objReader = new PHPExcel_Reader_Excel5();
		$data = $objReader->load($file);
		$objWorksheet = $data->getActiveSheet();
		$highestRow = $objWorksheet->getHighestRow();



		for ($i = 2; $i <= $highestRow; $i++) {



			$itemCode = $objWorksheet->getCellByColumnAndRow(2, $i)->getValue();
			$itemName = $objWorksheet->getCellByColumnAndRow(3, $i)->getValue();
			$itemDescription = $objWorksheet->getCellByColumnAndRow(4, $i)->getValue();

			$categoryName = $objWorksheet->getCellByColumnAndRow(24, $i)->getValue();
			//$subcategoryName = $objWorksheet->getCellByColumnAndRow(24, $i)->getValue();
			//$unitCost = $objWorksheet->getCellByColumnAndRow(6, $i)->getValue();
			//$sellingPrice = $objWorksheet->getCellByColumnAndRow(7, $i)->getValue();
			//$qtyOnHand = $objWorksheet->getCellByColumnAndRow(8, $i)->getValue();
			//$qtyAvailable = $objWorksheet->getCellByColumnAndRow(9, $i)->getValue();
			$imageName = $objWorksheet->getCellByColumnAndRow(28, $i)->getValue();



			if (!$category = getCategory($dbConnection, $categoryName)) {
				$category = createCategory($dbConnection, $categoryName);
			} else {
				$errors[] = "Category is not defined for the item [$itemName] [Line:{$i}]";
			}


			//subcategory will be created only if category available, if category available then it tries to find subcategory otherwise it will create new subcategory
//		if ($category) {
//			if (!$subcategory = getSubcategory($dbConnection, $category, $subcategoryName)) {
//				$subcategory = createSubcategory($dbConnection, $category, $subcategoryName);
//			}
//		}





			if (!$product = getProduct($dbConnection, $itemCode)) {
				$product = new Product();
				$product->categoryId = $category ? $category->id : null;
				$product->pdldes = $itemDescription;
				$product->pdlimage1 = $imageName;
				$product->pdlpdl = $itemCode;
				$product->pdlprdline = $itemName;
				$product->pdlsupsno = $supplier->supsno;
//			$product->pdluntprice = $unitCost;
//			$product->qty_available = $qtyAvailable;
//			$product->qty_on_hand = $qtyOnHand;
//			$product->sellingPrice = $sellingPrice;
//			$product->subCategoryId = $subcategory ? $subcategory->id : null;

				$product = createProduct($dbConnection, $product);
			}

			if ($product->pdlsno) {

				createProductExcelLookupDetail($dbConnection, $excelLookupId, $product->pdlsno);

				$productIdArr[] = $product->pdlsno;

				deleteProductPrices($dbConnection, $product);


				$q1 = (int) $objWorksheet->getCellByColumnAndRow(7, $i)->getValue();
				$p1 = $objWorksheet->getCellByColumnAndRow(8, $i)->getValue();

				$q2 = (int) $objWorksheet->getCellByColumnAndRow(9, $i)->getValue();
				$p2 = $objWorksheet->getCellByColumnAndRow(10, $i)->getValue();


				createProductPrice($dbConnection, array(
					'pdlsno' => $product->pdlsno,
					'pdpquantity_break_level' => 1,
					'qty_from' => $q1,
					'qty_to' => $q2,
					'pdpprice' => $p1
				));


				$q3 = (int) $objWorksheet->getCellByColumnAndRow(11, $i)->getValue();
				$p3 = $objWorksheet->getCellByColumnAndRow(12, $i)->getValue();


				createProductPrice($dbConnection, array(
					'pdlsno' => $product->pdlsno,
					'pdpquantity_break_level' => 2,
					'qty_from' => $q2,
					'qty_to' => $q3,
					'pdpprice' => $p2
				));

				$q4 = (int) $objWorksheet->getCellByColumnAndRow(13, $i)->getValue();
				$p4 = $objWorksheet->getCellByColumnAndRow(14, $i)->getValue();

				createProductPrice($dbConnection, array(
					'pdlsno' => $product->pdlsno,
					'pdpquantity_break_level' => 3,
					'qty_from' => $q3,
					'qty_to' => $q4,
					'pdpprice' => $p3
				));


				$q5 = (int) $objWorksheet->getCellByColumnAndRow(15, $i)->getValue();
				$p5 = $objWorksheet->getCellByColumnAndRow(16, $i)->getValue();

				createProductPrice($dbConnection, array(
					'pdlsno' => $product->pdlsno,
					'pdpquantity_break_level' => 4,
					'qty_from' => $q4,
					'qty_to' => $q5,
					'pdpprice' => $p4
				));


				$q6 = (int) $objWorksheet->getCellByColumnAndRow(17, $i)->getValue();
				$p6 = $objWorksheet->getCellByColumnAndRow(18, $i)->getValue();

				createProductPrice($dbConnection, array(
					'pdlsno' => $product->pdlsno,
					'pdpquantity_break_level' => 5,
					'qty_from' => $q5,
					'qty_to' => $q6,
					'pdpprice' => $p5
				));


				$q7 = (int) $objWorksheet->getCellByColumnAndRow(19, $i)->getValue();
				$p7 = $objWorksheet->getCellByColumnAndRow(20, $i)->getValue();

				createProductPrice($dbConnection, array(
					'pdlsno' => $product->pdlsno,
					'pdpquantity_break_level' => 6,
					'qty_from' => $q6,
					'qty_to' => $q7,
					'pdpprice' => $p6
				));



				$q8 = (int) $objWorksheet->getCellByColumnAndRow(21, $i)->getValue();
				$p8 = $objWorksheet->getCellByColumnAndRow(22, $i)->getValue();

				createProductPrice($dbConnection, array(
					'pdlsno' => $product->pdlsno,
					'pdpquantity_break_level' => 7,
					'qty_from' => $q7,
					'qty_to' => $q8,
					'pdpprice' => $p7
				));

				createProductPrice($dbConnection, array(
					'pdlsno' => $product->pdlsno,
					'pdpquantity_break_level' => 8,
					'qty_from' => $q8,
					'qty_to' => 9999999999,
					'pdpprice' => $p8
				));
			} else {
				$errors[] = "Cannot create a product for the item [$itemName] [Line:{$i}]";
			}
		}
	} catch (Exception $e) {
		$errors['exception'] = $e->getMessage();
	}

	return $errors;
}

try {

	$dbConnection = getDBConnection();

	$ftp_conn = getFtpConnection($remote_ftp_location_configs);
	
	
	
	$remote_file_list = getRemoteFileList($ftp_conn, $ftp_server_dir);
	
	
	
	//$filterdFileList = filterRemoteFilesLocal($remote_file_list, $productExcelLookupList);
	$savedFileList = saveRemoteFilesInLocal($ftp_conn, $dbConnection, $ftp_server_dir, $local_dir, $remote_file_list);
	ftp_close($ftp_conn);

	foreach ($savedFileList as $fileName) {
		$supCode = getProductSupplierCode($local_dir . '/' . $fileName);
		if ($supCode && $supplier = getSupplierByCode($dbConnection, $supCode)) {
			if ($supplier->ftpAutoProductUploadEnable) {
				
				if (!getProductExcel($dbConnection, $fileName)) {
					insertProductExcelLookupList($dbConnection, $fileName, 1, '');
				}
				$productExcelLookupList = getProductExcelLookupList($dbConnection);
				
				$excelLookupId = array_search($fileName, $productExcelLookupList);
				if (!$errors = validateFile($local_dir . '/' . $fileName)) {
					$errors = uploadProducts($dbConnection, $local_dir . '/' . $fileName, $supplier, $excelLookupId);

					if (isset($errors['exception'])) {
						if ($excelLookupId) {
							updateProductExcelLookupList($dbConnection, $fileName, 1, $errors['exception']);
						} else {
							insertProductExcelLookupList($dbConnection, $fileName, 1, $errors['exception']);
						}
					} else {
						if ($excelLookupId) {
							updateProductExcelLookupList($dbConnection, $fileName, 0, implode(',', $errors));
						} else {
							insertProductExcelLookupList($dbConnection, $fileName, 0, implode(',', $errors));
						}
					}
				} else {
					$errors[] = 'File is not valid!';
					if ($excelLookupId) {
						updateProductExcelLookupList($dbConnection, $fileName, 1, implode(',', $errors));
					} else {
						insertProductExcelLookupList($dbConnection, $fileName, 1, implode(',', $errors));
					}
				}
			}
		}
	}
} catch (Exception $e) {
	//echo $e->getCode(), $e->getLine() . ' : ' . $e->getMessage();
}



