<?php
/**
 * Extend the implemetation of CustomerExcelImporter for prospect customer related operation when upload excel
 */

 class CustomerCRMExcelImporter extends CustomerExcelImporter 
 {
     protected $followupStatusId;
     protected $followupStatusName;
     protected $followupDateColumn;
     protected $crmCommentColumn;

     protected $crms = [];

     public function setFollowupStatusId($id) {
        $this->followupStatusId = $id;
        $this->followupStatusName = FollowupStatus::model()->findByPk($this->followupStatusId)->status;
        return $this;
     }

     public function setFollowupDateColumn($column = null) {
        $this->followupDateColumn = $column;
        return $this;
     }

     public function setCrmCommentColumn($column = null) {
        $this->crmCommentColumn = $column;
        return $this;
     }

     

    public function extractCRMForCustomers($column = 'C') {

        foreach ($this->extractedExcelData as $key => $data) {

            $name = $data[$column];
            $nextCallDate = PHPExcel_Style_NumberFormat::toFormattedString($data['B'], PHPExcel_Style_NumberFormat::FORMAT_DATE_YYYYMMDD) ;
            $dateEntered = PHPExcel_Style_NumberFormat::toFormattedString($data['E'], PHPExcel_Style_NumberFormat::FORMAT_DATE_YYYYMMDD) ;
            
            $followUpDate = DateTime::createFromFormat('y-m-d', $nextCallDate);
            $followupDateFormatted = $followUpDate ? $followUpDate->format('Y-m-d') : date('Y-m-d');

            $createdDate = DateTime::createFromFormat('y-m-d', $dateEntered);
            $createdDateFormatted = $createdDate ? $createdDate->format('Y-m-d') : date('Y-m-d');

            $notes = $data['G'];
            
            //check customer has already been fetched or created
            $key = strtolower(preg_replace('/\s+/',  '_', $name));
            
            if (@array_key_exists($key, $this->customers) && $customer = $this->customers[$key]) {
                $this->crms[$customer->cussno][] = ['nextCallDate' => $followupDateFormatted, 'dateEntered' => $createdDateFormatted, 'notes' =>$notes];                
            }
            
        }

        return $this;
    }

    public function generateCRMForCustomers(): Generator {
        $CATEGORY = SalesLog::CATEGORY_CUSTOMER;
        foreach($this->crms as $customerId => $crmData) {
            
            
            foreach($crmData as $data) {
               
                    
                    $crm = new SalesLog();
                    $crm->tbl_id = $customerId;
                    $crm->category = $CATEGORY;
                    $crm->followupSts_id = $this->followupStatusId;
                    $crm->createdBy = Yii::app()->user->id;
                    $crm->isIntrnl = 0;
                    $crm->isExtrnl = 1;
                    $crm->isTechnical = 0;                           
                    
                    $crm->comments = $data['notes'];
                    $crm->createdDtm = $data['dateEntered'];                   
                    $crm->followupDtm = $data['nextCallDate'];
                   
                    

                    yield $crm;
                    
                
            }            
        }
    }

   

    public function addCRMForCustomers() {
        
        foreach($this->generateCRMForCustomers() as $crm) {  
                      
           $crm->save(false);            
        }

        return $this;
    }

    public function getCrms() {
        return $this->crms;
    }

    public function writeLogs() {
        $rowCount = count($this->extractedExcelData);
        $fileName = basename($this->excelFilePath);

        if ($rowCount && $fileName) {
            $this->logs[] = "Data has been extracted by [{$rowCount}] rows from the {$fileName} file.". PHP_EOL;

            $customerCount = count($this->customers);
            if ($customerCount) {                
                $customerCount ? $this->logs[] = "[{$customerCount}] customers have been created/updated from the [{$fileName}] file.". PHP_EOL : '';
            }

            $crmCount = count($this->crms);
            if ($crmCount) { 
                $crmDataCount = 0;
                foreach($this->crms as $crm) {
                    $crmDataCount += count($crm);
                }   
                $crmCount ? $this->logs[] = "[{$crmDataCount}] CRM records have been created/updated for customers' data.". PHP_EOL : '';        
                
            }            
        }

        return $this;
    }



 }