<?php

/**
 * Extend the implemetation of ExcelImporter for customer related imports
 */

 class CustomerExcelImporter extends ExcelImporter 
 {
     protected $customers = [];

     protected $isProspect = false;
     protected $salespersonId;

     public function setIsProspect($isProspect = false) {
         $this->isProspect = $isProspect;
         return $this;
     }

     public function setSalespersonId($id) {
         $this->salespersonId = $id;
         
         return $this;
     }

     protected function generateCustomersByName($column = 'C'): Generator {
        foreach ($this->extractedExcelData as $key => $data) {

            $name = $data[$column];
            $address1 = $data['I'];
            $address2 = $data['J'];
            $address3 = $data['K'];
            $city = $data['L'];
            $state = $data['M'];
            $postalCode = $data['N'];
            $phone = $data['O'];
            //check customer has already been fetched or created
            $key = strtolower(preg_replace('/\s+/',  '_', $name));
            if (@array_key_exists($key, $this->customers)) {
                continue;
            }

            $criteria = new CDbCriteria;
            $criteria->condition = "cusnam =:customerName";
            $criteria->params = array(':customerName' => $name);
            $customer = Customer::model()->find($criteria);

            if (!$customer) {

                $customer = new Customer();
                $customer->cusnam = $name;      
                $customer->cusentddt = date('Y-m-d');          
                if($customer->save(false)) {
                    $customer->cuscus_fref = $customer->cussno;
                    $customer->cuscus = 'C' . $customer->cussno;
                    $customer->save(false);
                }
            }

            /** if customer already exsit update other fields */
            $customer->cusadd1 = $address1;
            $customer->cusadd2 = $address2;
            $customer->cusadd3 = $address3;
            $customer->custown = $city;
            $customer->cusstate = $state;
            $customer->cuspostcode = $postalCode;
            $customer->custel = $phone;

            $customer->isProspect = $this->isProspect;
            $customer->cussalespersonId = $this->salespersonId;
            
            $customer->save(false);

            yield $customer;
        }
    }

    public function createCustomersByName($column = 'C') {

        foreach ($this->generateCustomersByName($column) as $customer) {
            $key = strtolower(preg_replace('/\s+/',  '_', $customer->cusnam));
            $this->customers[$key] = $customer;
        }

        return $this;
    }

    public function getCustomers() {
        return $this->customers;
    }

 }