<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Merge customers into a given customer
 *
 * @author rajaera@gmail.com
 */
class CustomerMerger {

    protected $customersToBeMerged = []; // customers
    protected $customerMergeInto; // this will be the final customer which other customers are being merged into
    protected $validated = true;
    protected $errors = [];
    protected $logs = [];

    public function setCustomerToBeMergered($customerIdArr) {
        foreach ($customerIdArr as $cusno) {
            $this->customersToBeMerged[] = Customer::model()->find(array('condition' => "cussno = {$cusno}"));
        }

        $this->customersToBeMerged = array_filter($this->customersToBeMerged);

        return $this;
    }

    public function setCustomerMergeInto($cusno) {
        $this->customerMergeInto = Customer::model()->find(array('condition' => "cussno = {$cusno}"));

        return $this;
    }

    public function validate() {
        //check master customer and customer name of the merge into customer same as others
        foreach ($this->customersToBeMerged as $customer) {
            if (strtolower(trim($customer->cusnam)) !== strtolower(trim($this->customerMergeInto->cusnam))) {
                $this->validated = false;
                $this->errors[] = "Customer company name [{$customer->cussno}][{$customer->cusnam}] is not equal to merge into customer [{$this->customerMergeInto->cussno}][{$this->customerMergeInto->cusnam}]";
                break;
            }

            if ($customer->cusmcussno !== $this->customerMergeInto->cusmcussno) {
                $this->validated = false;
                $this->errors[] = "Master customer [{$customer->cussno}][{$customer->master->mcusnam}] is not equal to merge into customer [{$this->customerMergeInto->cussno}][{$this->customerMergeInto->master->mcusnam}]";
                break;
            }
        }

        return $this;
    }

    public function validated() {
        return $this->validated;
    }

    public function errors() {
        return $this->errors;
    }

    /**
     * Update all the customer references of related data such as quote, SO, job etc. before merge into     * 
     */
    protected function updateRelatedDataReference() {
        $log = ReferenceUpdater::OfCustomer($this->customersToBeMerged, $this->customerMergeInto);
        $this->logs = array_merge($this->logs, $log);
    }

    /**
     * Keep the given customer and remove all the other customers
     */
    public function merge() {
        //one of the main purpose of the merging is update the related data references with merge into customer reference
        $this->updateRelatedDataReference();
        //delete all the other customers which have been merged into main customer
        foreach ($this->customersToBeMerged as $customer) {
            
            $this->logs[] = "Customer [{$customer->cussno}][{$customer->cusnam}] has been deleted after merging into the customer [{$this->customerMergeInto->cussno}][{$this->customerMergeInto->cusnam}]";
            $customer->delete();
        }

        return $this;
    }

    public function writeLog() {
        foreach ($this->logs as $log) {
            $crm = new SalesLog();
            $crm->category = SalesLog::CATEGORY_OTHER;
            $crm->comments = $log;
            $crm->isIntrnl = 1;
            $crm->isExtrnl = 0;
            $crm->isTechnical = 1;
            $crm->createdDtm = date("Y-m-d H:i:s");
            $crm->createdBy = Yii::app()->user->id;
            $crm->save(fasle);
        }

        return $this;
    }
    
    public function getLogs() {
        
        return $this->logs;
    }
    
    public function logToString() {
        $markup = '<ul>';
        foreach ($this->logs as $log) {
            $markup .= "<li>{$log}</li>";
        }
        
         $markup .= '</ul>';
         
         return $markup;
    }

}
