<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Provide basic functionality to extract data from a excel sheet based on the excel library used in this class
 *
 * @author rajaera@gmail.com
 */
class ExcelImporter {

    protected $excelFilePath;
    protected $excelReader;
    protected $excelSheet;   
    
    protected $coloumnsToBeRead = 26; // deafult to read A - Z
    protected $extractedExcelData = [];

    public function __construct($file) {
        Yii::import('application.vendors.PHPExcel', true);
        $this->excelFilePath = $file;        
    }
    
    /**
     * this function must me called before any other excel sheet related activities
     */
    public function loadSheet() {
        try {
            if (pathinfo($this->excelFilePath, PATHINFO_EXTENSION) == "xls") {
                $this->excelReader = new PHPExcel_Reader_Excel5();
                $data = $this->excelReader->load($this->excelFilePath);
                $this->excelSheet = $data->getActiveSheet();
            }

            if (pathinfo($this->excelFilePath, PATHINFO_EXTENSION) == "xlsx") {
                $inputFileType = PHPExcel_IOFactory::identify($this->excelFilePath);
                $this->excelReader = PHPExcel_IOFactory::createReader($inputFileType);
                $this->excelReader->setReadDataOnly(true);

                $data = $this->excelReader->load($this->excelFilePath);
                $this->excelSheet = $data->getSheet(0);
            }
        } catch (Exception $e) {
            throw new Exception($e);
        }
        
        return this;
    }
    
    public function setColoumnsToBeRead($numberOfColumns = 26) {
        $this->coloumnsToBeRead = $numberOfColumns;
        
        return $this;
    }
    
    protected function extractDataGenerator(): Generator {
        $this->loadSheet();
        $objWorksheet = $this->excelSheet;
        $LETTER = 'A';
        for ($i = 1; $i <= $objWorksheet->getHighestRow(); $i++) {
            
            
            $excelRow = [];
            for($j = 0; $j <= $this->coloumnsToBeRead; $j++) 
            {
                $excelRow[$LETTER++] = $objWorksheet->getCellByColumnAndRow($j, $i)->getValue();
            }
            
            //reset letter 
            $LETTER = 'A';
            
            yield $excelRow;
        }
    }
    
    public function extractData() {
        
        foreach($this->extractDataGenerator() as $excelRow) {            
            array_push($this->extractedExcelData, $excelRow);
        }
        
        return $this;
    }
    
    public function getExtraxctedData() {
        return $this->extractedExcelData;
        
    }
}
