<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of FTPProductReader
 *
 * @author User
 */
class FTPSupplier {

    public $supsno;
    public $supsup_fref;
    public $ftpAutoProductUploadEnable;

}

class FTPCategory {

    public $id;
    public $name;
    public $description;

}

class FTPSubcategory {

    public $id;
    public $productCategoryId;
    public $name;
    public $description;

}

class FTPProduct {

    public $pdlsno;
    public $pdlprdsno;
    public $pdlprdline;
    public $pdlpdl;
    public $pdldes;
    public $pdlimage1;
    public $pdlsupsno;
    public $pdluntprice;
    public $sellingPrice;
    public $categoryId;
    public $subCategoryId;
    public $qty_on_hand;
    public $qty_available;

}

class FTPProductPrice {

    public $pdpsno;
    public $pdppdlsno;
    public $pdpquantity_break_level;
    public $pdpsquantity;
    public $pdpprice;
    public $pdpsellprice;

}

class FTPProductReader {

    protected $ftp_server_dir = "/public_ftp/promoproductsexcels/";
    protected $local_dir = 'excels';
    protected $remote_ftp_location_configs;

    /*
     * Get uploaded product excel name list
     */

    public function __construct(array $config) {
        if ($config) {
            $this->ftp_server_dir = isset($config['ftp_server_dir']) ? $config['ftp_server_dir'] : $this->ftp_server_dir;
            $this->local_dir = __DIR__ . '/../../' . (isset($config['local_dir']) ? $config['local_dir'] : $this->local_dir);
            $this->remote_ftp_location_configs = isset($config['remote_ftp_location_configs']) ? $config['remote_ftp_location_configs'] : $this->remote_ftp_location_configs;
        }
    }

    public function read() {

        $ftp_conn = $this->getFtpConnection($this->remote_ftp_location_configs);
        $remote_file_list = $this->getRemoteFileList($ftp_conn, $this->ftp_server_dir);

        $filterdFileList = $this->filterRemoteFilesLocal($remote_file_list, $this->getProductExcelLookupList());

        if ($filterdFileList) {

            $savedFileList = $this->saveRemoteFilesInLocal($ftp_conn, $this->ftp_server_dir, $this->local_dir, $remote_file_list);
            ftp_close($ftp_conn);



            foreach ($savedFileList as $fileName) {
                $supCode = $this->getProductSupplierCode($this->local_dir . '/' . $fileName);

                if ($supCode && $supplier = $this->getSupplierByCode($supCode)) {

                    if ($supplier->ftpAutoProductUploadEnable) {

                        if (!$this->getProductExcel($fileName)) {
                            $this->insertProductExcelLookupList($fileName, 1, '');
                        }
                        $productExcelLookupList = $this->getProductExcelLookupList();

                        $excelLookupId = array_search($fileName, $productExcelLookupList);
                        if (!$errors = $this->validateFile($this->local_dir . '/' . $fileName)) {
                            $errors = $this->uploadProducts($this->local_dir . '/' . $fileName, $supplier, $excelLookupId);
                            if (isset($errors['exception'])) {

                                if ($excelLookupId) {
                                    $this->updateProductExcelLookupList($fileName, 1, $errors['exception']);
                                } else {
                                    $this->insertProductExcelLookupList($fileName, 1, $errors['exception']);
                                }
                            } else {
                                if ($excelLookupId) {
                                    $this->updateProductExcelLookupList($fileName, 0, implode(',', $errors));
                                } else {
                                    $this->insertProductExcelLookupList($fileName, 0, implode(',', $errors));
                                }
                            }
                        } else {
                            $errors[] = 'File is not valid!';
                            if ($excelLookupId) {
                                $this->updateProductExcelLookupList($fileName, 1, implode(',', $errors));
                            } else {
                                $this->insertProductExcelLookupList($fileName, 1, implode(',', $errors));
                            }
                        }
                    }
                }
            }
        }
    }

    function getProductExcelLookupList() {
        $sql = "SELECT id, file_name FROM product_excel_lookup";
        $result = Yii::app()->db->createCommand($sql)->queryAll();

        $filesArr = array();
        foreach ($result as $row) {
            $filesArr[$row["id"]] = $row["file_name"];
        }

        return $filesArr;
    }

    function getProductExcel($fileName) {
        $sql = "SELECT id, file_name FROM product_excel_lookup WHERE  file_name = '$fileName'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        if ($result) {
            return array(
                $row["id"] = $row["file_name"]
            );
        }



        return null;
    }

    /*
     * @return Supplier object
     */

    function getSupplierByCode($supplierCode) {

        if (trim($supplierCode)) {

            if ($supmodel = Supplier::model()->find("supsup_fref = '$supplierCode'")) {

                $supplier = new FTPSupplier();
                $supplier->supsno = $supmodel->supsno;
                $supplier->supsup_fref = $supmodel->supsup_fref;
                $supplier->ftpAutoProductUploadEnable = $supmodel->ftpAutoProductUploadEnable;
                return $supplier;
            } else {
                return null;
            }
        }
    }

    /*
     * @return Category object
     */

    function getCategory($categoryName) {
        if (trim($categoryName)) {

            if ($catmodel = ProductCategory::model()->find("name = '$categoryName'")) {

                $category = new FTPCategory();
                $category->id = $catmodel->id;
                $category->name = $catmodel->name;
                $category->description = $catmodel->description;

                return $category;
            } else {
                return null;
            }
        }
    }

    /*
     * @return boolean
     */

    function createCategory($categoryName) {
        if (trim($categoryName)) {

            $category = new ProductCategory();
            $category->name = $categoryName;
            $category->description = $categoryName;
            $category->createdDate = $createdDate = date('Y-m-d');
            return $category->save(false);
        }
        return null;
    }

    /*
     * @return Subcategory object
     */

    function getSubcategory(FTPCategory $category, $subcategoryName) {
        if ($category && trim($subcategoryName)) {

            if ($subcatmodel = ProductSubCategory::model()->find("productCategoryId = '{$category->id}' AND name = '$subcategoryName'")) {
                $subcategory = new FTPSubcategory();
                $subcategory->id = $subcatmodel->id;
                $subcategory->productCategoryId = $subcatmodel->productCategoryId;
                $subcategory->name = $subcatmodel->name;
                $subcategory->description = $subcatmodel->description;

                return $subcategory;
            }
        }
        return null;
    }

    /*
     * @return Subcategory object
     */

    function createSubcategory(FTPCategory $category, $subcategoryName) {
        if ($category && trim($subcategoryName)) {

            $createdDate = date('Y-m-d');
            $subcatmodel = new ProductSubCategory();
            $subcatmodel->productCategoryId = $category->id;
            $subcatmodel->name = $subcategoryName;
            $subcatmodel->description = $subcategoryName;
            $subcatmodel->createdDate = $createdDate;


            if ($subcatmodel->save(false)) {
                return getSubcategory($category, $subcategoryName);
            }
        }
        return null;
    }

    /*
     * @return Product object
     */

    function getProduct($code) {
        if (trim($code)) {




            if ($productModel = ProductLine::model()->find("pdlpdl = '$code'")) {
                $product = new FTPProduct();
                $product->pdlsno = $productModel->pdlsno;
                $product->pdlprdsno = $productModel->pdlprdsno;
                $product->pdlprdline = $productModel->pdlprdline;
                $product->pdlpdl = $productModel->pdlpdl;
                $product->pdldes = $productModel->pdldes;
                $product->pdlimage1 = $productModel->pdlimage1;
                $product->pdlsupsno = $productModel->pdlsupsno;
                $product->pdluntprice = $productModel->pdluntprice;
                $product->categoryId = $productModel->categoryId;
                $product->subCategoryId = $productModel->subCategoryId;
                $product->qty_on_hand = $productModel->qty_on_hand;
                $product->qty_available = $productModel->qty_available;

                return $product;
            }
        }
        return null;
    }

    /*
     * @return Subcategory object
     */

    function createProduct(FTPProduct $product) {

        $createdDate = date('Y-m-d');
        $createdTime = date('H:i:s');

        $productModel = new ProductLine();
        $productModel->pdlprdline = $product->pdlprdline;
        $productModel->pdlpdl = $product->pdlpdl;
        $productModel->pdldes = $product->pdldes;
        $productModel->pdlimage1 = $product->pdlimage1;
        $productModel->pdlsupsno = $product->pdlsupsno;
        $productModel->pdluntprice = $product->pdluntprice;
        $productModel->sellingPrice = $product->sellingPrice;
        $productModel->categoryId = $product->categoryId;
        $productModel->subCategoryId = $product->subCategoryId;
        $productModel->qty_on_hand = $product->qty_on_hand;
        $productModel->qty_available = $product->qty_available;
        $productModel->pdlentddt = $createdDate;
        $productModel->pdlenttime = $createdTime;

        if ($productModel->save(false)) {

            return $this->getProduct($product->pdlpdl);
        }


        return null;
    }

    function updateProduct(FTPProduct $product) {

        $createdDate = date('Y-m-d');
        $createdTime = date('H:i:s');

        $productModel = ProductLine::model()->findByPk($product->pdlsno);
        $productModel->pdlprdline = $product->pdlprdline;
        $productModel->pdlpdl = $product->pdlpdl;
        $productModel->pdldes = $product->pdldes;
        $productModel->pdlimage1 = $product->pdlimage1;
        $productModel->pdlsupsno = $product->pdlsupsno;
        $productModel->pdluntprice = $product->pdluntprice;
        $productModel->sellingPrice = $product->sellingPrice;
        $productModel->categoryId = $product->categoryId;
        $productModel->subCategoryId = $product->subCategoryId;
        $productModel->qty_on_hand = $product->qty_on_hand;
        $productModel->qty_available = $product->qty_available;
        $productModel->pdlentddt = $createdDate;
        $productModel->pdlenttime = $createdTime;

        if ($productModel->save(false)) {
           
            return $product;
        } 


        return null;
    }

    function createProductPrice(array $price) {

        //if ($price['qty_from'] && $price['qty_to']) {
            
        if ((ctype_digit((string) $price['qty_from']) == true) && (ctype_digit((string) $price['qty_to']) == true) &&  $price['pdpprice'] > 0) {

            $qty_to = ($price['qty_to'] > 0 ? ($price['qty_to'] - 1) : 9999999999);
            $pp = new FTPProductPrice();
            $pp->pdppdlsno = $price['pdlsno'];
            $pp->pdpquantity_break_level = $price['pdpquantity_break_level'];
            $pp->pdpquantity = $price['qty_from'];
            $pp->pdpsquantity = $qty_to;

            $pricerounded = sprintf("%.2f", $price['pdpprice']);
            $pp->pdpprice = $pricerounded;


            $createdDate = date('Y-m-d');
            $createdTime = date('H:i:s');


            $prodcutPriceModel = new ProductPrice();
            $prodcutPriceModel->pdppdlsno = $pp->pdppdlsno;
            $prodcutPriceModel->pdpquantity_break_level = $pp->pdpquantity_break_level;
            $prodcutPriceModel->pdpquantity = $pp->pdpquantity;
            $prodcutPriceModel->pdpsquantity = $pp->pdpsquantity;
            $prodcutPriceModel->pdpprice = $pp->pdpprice;
            $prodcutPriceModel->pdpentddt = $createdDate;
            $prodcutPriceModel->pdpenttime = $createdTime;

            return $prodcutPriceModel->save(false);
        }

        return false;
    }

    function createProductExcelLookupDetail($excelLookupId, $productId) {
        if ($excelLookupId && $productId) {


            $excelLookupDetailModel = new ProductExcelLookupDetails();
            $excelLookupDetailModel->product_excel_lookup_id = $excelLookupId;
            $excelLookupDetailModel->pdlsno = $productId;


            return $excelLookupDetailModel->save(false);
        }

        return false;
    }

    /*
     * Delete all price quantity breaks related to the given product
     */

    function deleteProductPrices(FTPProduct $product) {
        $sql = 'DELETE FROM product_price WHERE pdppdlsno = :productCode';

        $result = Yii::app()->db->createCommand($sql)
                ->bindParam(':productCode', $product->pdlsno, PDO::PARAM_INT)
                ->execute();


        if ($result->num_rows > 0) {
            return true;
        }

        return false;
    }

    /*
     * Insert saved product excel file name
     */

    function insertProductExcelLookupList($fileName, $toBeRead, $logMessage) {
        if (trim($fileName)) {


            $createdDate = date('Y-m-d');


            $excelLookupModel = new ProductExcelLookup();
            $excelLookupModel->file_name = $fileName;
            $excelLookupModel->to_be_read = $toBeRead;
            $excelLookupModel->log_message = $logMessage;
            $excelLookupModel->created_date = $createdDate;
            return $excelLookupModel->save(false);
        }



        return false;
    }

    /*
     * Insert saved product excel file name
     */

    function updateProductExcelLookupList($fileName, $toBeRead, $logMessage) {
        if (trim($fileName)) {

            $excelLookupModel = ProductExcelLookup::model()->find("file_name = '{$fileName}'");

            if ($excelLookupModel) {
                $excelLookupModel->to_be_read = $toBeRead;
                $excelLookupModel->log_message = $logMessage;
                return $excelLookupModel->save(false);
            }
        }



        return false;
    }

    function getFtpConnection($ftp_config = array()) {
        //remote server
        $ftp_conn = ftp_connect($ftp_config['ftp_server']);

        ftp_login($ftp_conn, $ftp_config['ftp_user'], $ftp_config['ftp_password']);

        ftp_pasv($ftp_conn, true);

        return $ftp_conn;
    }

    function getRemoteFileList($ftp_conn, $ftp_server_dir = "/public_ftp/", $file_extensions = array('xls', 'xlsx')) {

// get file list of current directory
        $file_list = ftp_nlist($ftp_conn, $ftp_server_dir);


        $request_file_list = array();
        foreach ($file_list as $file_name) {

            $file_parts = pathinfo($file_name);
            if (isset($file_parts['extension']) && in_array($file_parts['extension'], $file_extensions)) {

                $request_file_list[] = basename($file_name);
            }
        }

        return $request_file_list;
    }

    function filterRemoteFilesLocal($remoteFiles, $localFiles = array()) {
        return $localFiles ? array_diff($remoteFiles, $localFiles) : $remoteFiles;
    }

    /*
     * 
     * Save remote excel files in local and return file name list
     * @return array file list
     */

    function saveRemoteFilesInLocal($ftp_conn, $ftp_server_dir, $local_dir, $file_list) {
        if (!file_exists($local_dir)) {
            @mkdir($local_dir, 0755);
        }
        $savedFileList = array();
        foreach ($file_list as $key => $file_name) {

            $server_file = $ftp_server_dir . $file_name;
            $local_file = fopen($local_dir . '/' . $file_name, 'w+');
            if (ftp_fget($ftp_conn, $local_file, $server_file, FTP_BINARY)) {
                
                $savedFileList[] = $file_name;                
            }
        }

        return $savedFileList;
    }

    function getProductSupplierCode($file) {

        $objWorksheet = $this->getObjectWorkSheet($file);
        $highestRow = $objWorksheet->getHighestRow();

        if ($objWorksheet) {
            for ($i = 1; $i <= $highestRow; $i++) {
                $suplierCode = $objWorksheet->getCellByColumnAndRow(0, $i)->getValue();
                if (!in_array(strtolower($suplierCode), array('supplier', 'sup', 'suplier', 'supplier_name', 'no_supplier'))) {
                    return $suplierCode;
                }
            }
        }



        return '';
    }

    /* Validate excel file
     * @return array of errors if available
     */

    function validateFile($file) {
        $errors = array();
        $objWorksheet = $this->getObjectWorkSheet($file);
        $highestRow = $objWorksheet->getHighestRow();

        if ($objWorksheet) {
            try {
                for ($i = 2; $i <= $highestRow; $i++) {



                    $itemCode = trim($objWorksheet->getCellByColumnAndRow(2, $i)->getValue());
                    $itemName = trim($objWorksheet->getCellByColumnAndRow(3, $i)->getValue());
                    $itemDescription = trim($objWorksheet->getCellByColumnAndRow(4, $i)->getValue());

                    $categoryName = trim($objWorksheet->getCellByColumnAndRow(24, $i)->getValue());
                    //$subcategoryName = $objWorksheet->getCellByColumnAndRow(24, $i)->getValue();
                    //$unitCost = $objWorksheet->getCellByColumnAndRow(6, $i)->getValue();
                    //$sellingPrice = $objWorksheet->getCellByColumnAndRow(7, $i)->getValue();
                    //$qtyOnHand = $objWorksheet->getCellByColumnAndRow(8, $i)->getValue();
                    //$qtyAvailable = $objWorksheet->getCellByColumnAndRow(9, $i)->getValue();
                    $imageName = trim($objWorksheet->getCellByColumnAndRow(28, $i)->getValue());

                    if (!$itemCode) {
                        $errors[] = "Item code was not found! [Line:$i]";
                    }

                    if (ctype_digit($itemCode)) {
                        $errors[] = "Item code [$itemCode] is not valid! [Line:$i]";
                    }

                    if (!$itemName) {
                        $errors[] = "Item name [$itemName] is not valid! [Line:$i]";
                    }

                    if (ctype_digit($itemName)) {
                        $errors[] = "Item name [$itemName] is not valid! [Line:$i]";
                    }

                    if (!$itemDescription) {
                        $errors[] = "Item description [$itemDescription] is not valid! [Line:$i]";
                    }

                    if (ctype_digit($itemDescription)) {
                        $errors[] = "Item description [$itemDescription] is not valid! [Line:$i]";
                    }

                    if (ctype_digit($imageName)) {
                        $errors[] = "Image name [$imageName] is not valid! [Line:$i]";
                    }
                }
            } catch (Exception $e) {
                $errors[] = $e->getMessage();
            }
        } else {
            $errors[] = "No object worksheet for the file [{$file}]";
        }

        return $errors;
    }

    /*
     * @return array of product ids
     */

    function uploadProducts($file, FTPSupplier $supplier, $excelLookupId) {
        $errors = array();

        try {

            $objWorksheet = $this->getObjectWorkSheet($file);
            $highestRow = $objWorksheet->getHighestRow();

            if ($objWorksheet) {
                $productIdArr = array();
                for ($i = 2; $i <= $highestRow; $i++) {



                    $itemCode = $objWorksheet->getCellByColumnAndRow(2, $i)->getValue();
                    $itemName = $objWorksheet->getCellByColumnAndRow(3, $i)->getValue();
                    $itemDescription = $objWorksheet->getCellByColumnAndRow(4, $i)->getValue();

                    $categoryName = $objWorksheet->getCellByColumnAndRow(24, $i)->getValue();
                    //$subcategoryName = $objWorksheet->getCellByColumnAndRow(24, $i)->getValue();
                    //$unitCost = $objWorksheet->getCellByColumnAndRow(6, $i)->getValue();
                    //$sellingPrice = $objWorksheet->getCellByColumnAndRow(7, $i)->getValue();
                    //$qtyOnHand = $objWorksheet->getCellByColumnAndRow(8, $i)->getValue();
                    //$qtyAvailable = $objWorksheet->getCellByColumnAndRow(9, $i)->getValue();
                    $imageName = $objWorksheet->getCellByColumnAndRow(28, $i)->getValue();



                    if (!$category = $this->getCategory($categoryName)) {
                        $category = $this->createCategory($categoryName);
                        if (!$category) {
                            $errors[] = "Could not create category for the category name [$categoryName] [Line:{$i}]";
                        }
                    }

                    //set product details
                    $product = new FTPProduct();
                    $product->categoryId = $category ? $category->id : null;
                    $product->pdldes = $itemDescription;
                    $product->pdlimage1 = $imageName;
                    $product->pdlpdl = $itemCode;
                    $product->pdlprdline = $itemName;
                    $product->pdlsupsno = $supplier->supsno;
                    //$product->pdluntprice = $unitCost;
                    //$product->qty_available = $qtyAvailable;
                    //$product->qty_on_hand = $qtyOnHand;
                    //$product->sellingPrice = $sellingPrice;
                    //$product->subCategoryId = $subcategory ? $subcategory->id : null;



                    if (!$oldProduct = $this->getProduct($itemCode)) {
                        //if not product in database create new one

                        $product = $this->createProduct($product);
                    } else {
                        //then update product details in database
                        $product->pdlsno = $oldProduct->pdlsno;
                        $product = $this->updateProduct($product);
                    }

                    //check database item is created
                    if ($product->pdlsno) {

                        $this->createProductExcelLookupDetail($excelLookupId, $product->pdlsno);

                        $productIdArr[] = $product->pdlsno;

                        $this->deleteProductPrices($product);

                        


                        $q1 = (int) $objWorksheet->getCellByColumnAndRow(7, $i)->getValue();
                        $p1 = $objWorksheet->getCellByColumnAndRow(8, $i)->getValue();
                        $q2 = (int) $objWorksheet->getCellByColumnAndRow(9, $i)->getValue();
                        
                        
                        
                        
                        $this->createProductPrice(array(
                                    'pdlsno' => $product->pdlsno,
                                    'pdpquantity_break_level' => 1,
                                    'qty_from' => $q1,
                                    'qty_to' => $q2,
                                    'pdpprice' => $p1
                                ));


                        $p2 = $objWorksheet->getCellByColumnAndRow(10, $i)->getValue();
                        $q3 = (int) $objWorksheet->getCellByColumnAndRow(11, $i)->getValue();
                        


                        $this->createProductPrice(array(
                            'pdlsno' => $product->pdlsno,
                            'pdpquantity_break_level' => 2,
                            'qty_from' => $q2,
                            'qty_to' => $q3,
                            'pdpprice' => $p2
                        ));

                        $p3 = $objWorksheet->getCellByColumnAndRow(12, $i)->getValue();
                        $q4 = (int) $objWorksheet->getCellByColumnAndRow(13, $i)->getValue();
                        

                        $this->createProductPrice(array(
                            'pdlsno' => $product->pdlsno,
                            'pdpquantity_break_level' => 3,
                            'qty_from' => $q3,
                            'qty_to' => $q4,
                            'pdpprice' => $p3
                        ));


                        $p4 = $objWorksheet->getCellByColumnAndRow(14, $i)->getValue();
                        $q5 = (int) $objWorksheet->getCellByColumnAndRow(15, $i)->getValue();
                        

                        $this->createProductPrice(array(
                            'pdlsno' => $product->pdlsno,
                            'pdpquantity_break_level' => 4,
                            'qty_from' => $q4,
                            'qty_to' => $q5,
                            'pdpprice' => $p4
                        ));


                        $p5 = $objWorksheet->getCellByColumnAndRow(16, $i)->getValue();
                        $q6 = (int) $objWorksheet->getCellByColumnAndRow(17, $i)->getValue();
                        

                        $this->createProductPrice(array(
                            'pdlsno' => $product->pdlsno,
                            'pdpquantity_break_level' => 5,
                            'qty_from' => $q5,
                            'qty_to' => $q6,
                            'pdpprice' => $p5
                        ));

                        
                        $p6 = $objWorksheet->getCellByColumnAndRow(18, $i)->getValue();
                        $q7 = (int) $objWorksheet->getCellByColumnAndRow(19, $i)->getValue();
                        

                        $this->createProductPrice(array(
                            'pdlsno' => $product->pdlsno,
                            'pdpquantity_break_level' => 6,
                            'qty_from' => $q6,
                            'qty_to' => $q7,
                            'pdpprice' => $p6
                        ));


                        $p7 = $objWorksheet->getCellByColumnAndRow(20, $i)->getValue();
                        $q8 = (int) $objWorksheet->getCellByColumnAndRow(21, $i)->getValue();
                        $p8 = $objWorksheet->getCellByColumnAndRow(22, $i)->getValue();

                        $this->createProductPrice(array(
                            'pdlsno' => $product->pdlsno,
                            'pdpquantity_break_level' => 7,
                            'qty_from' => $q7,
                            'qty_to' => $q8,
                            'pdpprice' => $p7
                        ));

                        $this->createProductPrice(array(
                            'pdlsno' => $product->pdlsno,
                            'pdpquantity_break_level' => 8,
                            'qty_from' => $q8,
                            'qty_to' => 9999999999,
                            'pdpprice' => $p8
                        ));
                    } else {
                        $errors[] = "Cannot create a product for the item [$itemName] [Line:{$i}]";
                    }
                }
            } else {
                $errors[] = "No object worksheet for the file [{$file}]";
            }
        } catch (Exception $e) {
            $errors['exception'] = $e->getMessage();
        }

        return $errors;
    }

    public function getObjectWorkSheet($file) {
        Yii::import('application.vendors.PHPExcel', true);

        $ext = pathinfo($file, PATHINFO_EXTENSION);
        try {
            if ($ext == "xls") {
                $objReader = new PHPExcel_Reader_Excel5();
                $data = $objReader->load($file);
                $objWorksheet = $data->getActiveSheet();
                //$highestRow = $objWorksheet->getHighestRow();
                return $objWorksheet;
            } else if ($ext == "xlsx") {
                $inputFileType = PHPExcel_IOFactory::identify($file);
                $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                $objReader->setReadDataOnly(true);
                $data = $objReader->load($file);
                $objWorksheet = $data->getSheet(0);
                return $objWorksheet;
                //$highestRow = $objWorksheet->getHighestRow();
            }
        } catch (Exception $e) {
            dir("Error loading file " . pathinfo($file, PATHINFO_BASENAME) . '": ' . $e->getMessage());
        }

        return null;
    }

}
