<?php

class PriceCalculator
{

	public static function getSubTotal($model)
	{
		$subTotal = 0;
		if (!empty($model) && $model instanceof Workorder) {

			$workorderDetails = Workorderdetails::model()->findAll(array('condition' => "workorderId = {$model->id}"));

			foreach ($workorderDetails as $data) {
				$subTotal += $data->sellPriceExVat * $data->prodQty;
			}
		} else if (!empty($model) && $model instanceof Quatation) {

			$quoteDetails = QuatationDetails::model()->findAll(array('condition' => "quoteid = {$model->id}"));

			foreach ($quoteDetails as $data) {
				$subTotal += $data->sellunitprice_ex_vat * $data->qty;
			}
		} else if (!empty($model) && $model instanceof Invoice) {
			$invoicedtls = InvoiceDetail::model()->findAll("invoice_id = '{$model->id}'");

			foreach ($invoicedtls as $data) {
				$subTotal += $data->sellPriceExVat * $data->qty;
			}
		}

		return $subTotal;
	}

    public static function getSubTotalWithoutHideRows($model) {
        $subTotal = 0;
        if (!empty($model) && $model instanceof Workorder) {

            $workorderDetails = Workorderdetails::model()->findAll(array('condition' => "workorderId = {$model->id}"));

            foreach ($workorderDetails as $data) {
                if ($data->hide_on_pdf) {
                    continue;
                }
                $subTotal += $data->sellPriceExVat * $data->prodQty;
            }
        } else if (!empty($model) && $model instanceof Quatation) {

            $quoteDetails = QuatationDetails::model()->findAll(array('condition' => "quoteid = {$model->id}"));

            foreach ($quoteDetails as $data) {
                if ($data->hide_on_pdf) {
                    continue;
                }
                $subTotal += $data->sellunitprice_ex_vat * $data->qty;
            }
        } else if (!empty($model) && $model instanceof Invoice) {
            $invoicedtls = InvoiceDetail::model()->findAll("invoice_id = '{$model->id}'");

            foreach ($invoicedtls as $data) {
                if ($data->hide_on_pdf) {
                    continue;
                }
                $subTotal += $data->sellPriceExVat * $data->qty;
            }
        }

        return $subTotal;
    }

    public static function getGSTTotal($model) {
		$gst = floatval(GlobalVars::get('GST'));
		if (!empty($model) && $model instanceof Workorder) {
			$workorderDetails = Workorderdetails::model()->findAll(array('condition' => "workorderId = {$model->id}"));

			$gstTotal = 0;
			foreach ($workorderDetails as $data) {
				$taxRate = 0;
				$taxCode = SystemTaxCode::model()->findByPk($data->systemTaxRateId);
				if ($taxCode) {
					$taxRate = $taxCode->rate;
					$gstTotal += $taxRate ? (( ($data->sellPriceExVat * $data->prodQty) * $taxRate) - ($data->sellPriceExVat * $data->prodQty)) : 0;
				} else {
					$taxRate = $gst;
					$gstTotal += $taxRate ? ((($data->sellPriceExVat * $data->prodQty) * $taxRate) - ($data->sellPriceExVat * $data->prodQty)) : 0;
				}
			}
			
			return $gstTotal;
		} else if (!empty($model) && $model instanceof Quatation) {
			$quoteDetails = QuatationDetails::model()->findAll(array('condition' => "quoteid = {$model->id}"));



			$gstTotal = 0;
			foreach ($quoteDetails as $data) {
				$taxRate = 0;
				$taxCode = SystemTaxCode::model()->findByPk($data->systemTaxRateId);
				if ($taxCode) {
					$taxRate = $taxCode->rate;
					$gstTotal += $taxRate ? (( ($data->sellunitprice_ex_vat * $data->qty) * $taxRate) - ($data->sellunitprice_ex_vat * $data->qty)) : 0;
				} else {
					$taxRate = $gst;
					$gstTotal += $taxRate ? (( ($data->sellunitprice_ex_vat * $data->qty) * $taxRate) - ($data->sellunitprice_ex_vat * $data->qty)) : 0;
				}
			}


			return $gstTotal;
		} else if (!empty($model) && $model instanceof Invoice) {
			$invoicedtls = InvoiceDetail::model()->findAll("invoice_id = '{$model->id}'");

			
			$gstTotal = 0;
			foreach ($invoicedtls as $data) {
				$taxRate = 0;
				$taxCode = SystemTaxCode::model()->findByPk($data->systemTaxRateId);
				if ($taxCode) {
					$taxRate = $taxCode->rate;
					$gstTotal += $taxRate ? (( ($data->sellPriceExVat * $data->qty) * $taxRate) - ($data->sellPriceExVat * $data->qty)) : 0;
				} else {
					$taxRate = $gst;
					$gstTotal += $taxRate ? (( ($data->sellPriceExVat * $data->qty) * $taxRate) - ($data->sellPriceExVat * $data->qty)) : 0;
				}
			}

			return $gstTotal;
		}
		return null;
	}

    public static function getGSTTotalWithoutHideRows($model) {
        $gst = floatval(GlobalVars::get('GST'));
        if (!empty($model) && $model instanceof Workorder) {
            $workorderDetails = Workorderdetails::model()->findAll(array('condition' => "workorderId = {$model->id}"));

            $gstTotal = 0;
            foreach ($workorderDetails as $data) {
                if ($data->hide_on_pdf) {
                    continue;
                }
                $taxRate = 0;
                $taxCode = SystemTaxCode::model()->findByPk($data->systemTaxRateId);
                if ($taxCode) {
                    $taxRate = $taxCode->rate;
                    $gstTotal += $taxRate ? (( ( $data->sellPriceExVat * $data->prodQty) * $taxRate) - ( $data->sellPriceExVat * $data->prodQty)) : 0;
                } else {
                    $taxRate = $gst;
                    $gstTotal += $taxRate ? (( ( $data->sellPriceExVat * $data->prodQty) * $taxRate) - ( $data->sellPriceExVat * $data->prodQty)) : 0;
                }
            }

            return $gstTotal;
        } else if (!empty($model) && $model instanceof Quatation) {
            $quoteDetails = QuatationDetails::model()->findAll(array('condition' => "quoteid = {$model->id}"));



            $gstTotal = 0;
            foreach ($quoteDetails as $data) {
                if ($data->hide_on_pdf) {
                    continue;
                }
                $taxRate = 0;
                $taxCode = SystemTaxCode::model()->findByPk($data->systemTaxRateId);
                if ($taxCode) {
                    $taxRate = $taxCode->rate;
                    $gstTotal += $taxRate ? (( ($data->sellunitprice_ex_vat * $data->qty) * $taxRate) - ($data->sellunitprice_ex_vat * $data->qty)) : 0;
                } else {
                    $taxRate = $gst;
                    $gstTotal += $taxRate ? (( ($data->sellunitprice_ex_vat * $data->qty) * $taxRate) - ($data->sellunitprice_ex_vat * $data->qty)) : 0;
                }
            }


            return $gstTotal;
        } else if (!empty($model) && $model instanceof Invoice) {
            $invoicedtls = InvoiceDetail::model()->findAll("invoice_id = '{$model->id}'");


            $gstTotal = 0;
            foreach ($invoicedtls as $data) {
                if ($data->hide_on_pdf) {
                    continue;
                }
                $taxRate = 0;
                $taxCode = SystemTaxCode::model()->findByPk($data->systemTaxRateId);
                if ($taxCode) {
                    $taxRate = $taxCode->rate;
                    $gstTotal += $taxRate ? (( ($data->sellPriceExVat * $data->qty) * $taxRate) - ($data->sellPriceExVat * $data->qty)) : 0;
                } else {
                    $taxRate = $gst;
                    $gstTotal += $taxRate ? (( ($data->sellPriceExVat * $data->qty) * $taxRate) - ($data->sellPriceExVat * $data->qty)) : 0;
                }
            }

            return $gstTotal;
        }
        return null;
    }

    public static function getItemSellingPrices(array $param) {
		$rounding_precision = $param['rounding_precision'];
		$item_cost = $param['item_cost'];
		$markup_rate = $param['markup_rate'];
		$discount_percentage = $param['discount_percentage'];
		$usd_freight = $param['usd_freight'];
		$usd_freight_markup_rate = $param['usd_freight_markup_rate'];

		$quantity = $param['quantity'];




		$prodMarkedUpPrice = $markup_rate ? round(($item_cost * $markup_rate), $rounding_precision) : $item_cost;

		$prodDiscRate = round(($discount_percentage / 100), strlen($discount_percentage));
		$prodDiscountedPrice = $prodDiscRate ? round(($prodMarkedUpPrice - ($prodMarkedUpPrice * $prodDiscRate)), $rounding_precision) : $prodMarkedUpPrice;

		$usdFreightUnitCost = round(($usd_freight / $quantity), $rounding_precision);
		$usdFreightUnitCostWithMarkedUp = $usdFreightUnitCost * $usd_freight_markup_rate;

		$prodUsdFreightedPrice = $prodDiscountedPrice + round(($usdFreightUnitCostWithMarkedUp), $rounding_precision);


		return array(
			'prodMarkedUpPrice' => $prodMarkedUpPrice,
			'usdFreightUnitCostWithMarkedUp' => $usdFreightUnitCostWithMarkedUp,
			'prodUsdFreigtedPrice' => $prodUsdFreightedPrice
		);
	}

    public static function getGSTOnLine($model) {
        $gst = floatval(GlobalVars::get('GST'));
        if (!empty($model) && $model instanceof InvoiceDetail) {



            $gstTotal = 0;

            $taxRate = 0;
            $taxCode = SystemTaxCode::model()->findByPk($model->systemTaxRateId);
            if ($taxCode) {
                $taxRate = $taxCode->rate;
                $gstTotal += $taxRate ? (($model->sellPriceExVat * $taxRate) - $model->sellPriceExVat) : 0;
            } else {
                $taxRate = $gst;
                $gstTotal += $taxRate ? (($model->sellPriceExVat * $taxRate) - $model->sellPriceExVat) : 0;
}


            return $gstTotal;
        }
        return 0;
    }

}

?>