<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ProductRemover
 *
 * @author Eranga
 */
class ProductRemover {

    protected $productGroupId;
    protected $webstoreUuid;
    protected $supplierId;
    protected $productsToBeDeleted;
    protected $validated = true;
    protected $logs = [];

    public function setProductGroupId($productGroupId) {
        $this->productGroupId = $productGroupId;

        return $this;
    }

    public function setWebStoreUuid($uuid) {
        $this->webstoreUuid = $uuid;
        return $this;
    }

    public function setSupplierId($supplierId) {
        $this->supplierId = $supplierId;
        return $this;
    }

    public function filterProductsToBeDeleted() {
        //if one of the following has value
        if (array_filter(array($this->productGroupId, $this->webstoreUuid, $this->supplierId))) {
            $criteria = new CDbCriteria;

            if ($this->productGroupId) {

                $productIdArr = CHtml::listData(ProductGroupDetail::model()->findAll(array('condition' => "product_group_id = {$this->productGroupId}")), 'id', 'pdlsno');

                $criteria->addInCondition('pdlsno', $productIdArr);
            }

            if ($this->webstoreUuid) {
                $criteria->addCondition("webstore_uuid = '{$this->webstoreUuid}'");
            }

            if ($this->supplierId) {
                $criteria->addCondition("pdlsupsno = {$this->supplierId}");
            }

            $this->productsToBeDeleted = ProductLine::model()->findAll($criteria);
        }

        return $this;
    }

    public function backupProducts() {
        
        $backupCount = [];
        foreach ($this->productsToBeDeleted as $product) {
            $backupProduct = new ProductLineBackup();
            $backupProduct->setAttributes($product->attributes);
            $backupCount[] = $backupProduct->save(false);
        }
        
        $count = count($backupCount);
        $this->logs[] = "$count Products have been copied into the backup table.";

        return $this;
    }

    public function delete() {

        $deletedProducts = [];
        foreach ($this->productsToBeDeleted as $product) {
            
            if (UsageChecker::productInUse($product->pdlsno)) {
                $this->logs[] = "Cannot delete the product [{$product->pdlpdl} : {$product->pdldes}]. The product in use.";
                continue;
            }
            
            $code = $product->pdlpdl;
            if ($product->delete()) {
                $deletedProducts[] = $code;
            } else {
                $this->logs[] = "Can not delete the product [{$product->pdlpdl} : {$product->pdldes}].";
            }
        }
        
        $this->logs[] = "Following products have been deleted successfully. [" . implode(',', $deletedProducts) . "]";

        return $this;
    }
    
    public function writeLog() {
        foreach ($this->logs as $log) {
            $crm = new SalesLog();
            $crm->category = SalesLog::CATEGORY_PRODUCT;
            $crm->comments = $log;
            $crm->isIntrnl = 0;
            $crm->isExtrnl = 0;
            $crm->isTechnical = 1;
            $crm->createdDtm = date("Y-m-d H:i:s");
            $crm->createdBy = Yii::app()->user->id;
            $crm->save(fasle);
            
        }
        
        return $this;
    }
    
    public function logToString() {
        $markup = '<ul>';
        foreach ($this->logs as $log) {
            $markup .= "<li>{$log}</li>";
        }
        
         $markup .= '</ul>';
         
         return $markup;
    }

}
