<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Update a provided references for defined models data by CDB criteria
 *
 * @author rajaera@gmail.com
 */
class ReferenceUpdater {

    protected static $logs = [];

    /**
     * Add more customer reference models to be updated as needed
     */
    protected static function updateCustomerReferences($forCustomers, $customerMergeInto): Generator {

        foreach ($forCustomers as $customer) {
            
            //if customer is merge into customer them it must be avoided
            if($customer->cussno === $customerMergeInto->cussno) {
                continue;
            }
            
            $invoices = Invoice::model()->findAll(array('condition' => "customer_id = {$customer->cussno}"));
            foreach ($invoices as $invoice) {
                $log = "Customer reference of the invoice [{$invoice->id}][{$invoice->invoiceNum}] has been updated to [{$customerMergeInto->cussno}] from [{$invoice->customer_id}]";
                $invoice->customer_id = $customerMergeInto->cussno;
                $invoice->save(false);
                yield $log;
            }

            $jobs = Jobs::model()->findAll(array('condition' => "cus_fref = '{$customer->cuscus_fref}'"));
            foreach ($jobs as $job) {
                $log = "Customer reference of the jobs [{$job->id}][{$job->jobNum}] has been updated to [{$customerMergeInto->cuscus_fref}] from [{$job->cus_fref}]";
                $job->cus_fref = $customerMergeInto->cuscus_fref;
                $job->save(false);
                yield $log;
            }

            $quotations = Quatation::model()->findAll(array('condition' => "cus_fref = '{$customer->cuscus_fref}'"));
            foreach ($quotations as $quote) {
                $log = "Customer reference of the quotation [{$quote->id}][{$quote->quoteno}] has been updated to [{$customerMergeInto->cuscus_fref}] from [{$quote->cus_fref}]";
                $quote->cus_fref = $customerMergeInto->cuscus_fref;
                $quote->save(false);
                yield $log;
            }

            $crms = SalesLog::model()->findAll(array('condition' => "category = 'Customer' AND tbl_id = {$customer->cussno}"));
            foreach ($crms as $crm) {
                $log = "Customer reference of the crm data [{$crm->id} has been updated to [{$customerMergeInto->cussno}] from [{$crm->tbl_id}]";
                $crm->tbl_id = $customerMergeInto->cussno;
                $crm->save(false);
                yield $log;
            }

            $webstoreUsers = WebstoreUser::model()->findAll(array('condition' => "customer_id = {$customer->cussno}"));
            foreach ($webstoreUsers as $webuser) {
                $log = "Customer reference of the web store user [{$webuser->id}][{$webuser->username}] has been updated to [{$customerMergeInto->cussno}] from [{$webuser->customer_id}]";
                $webuser->customer_id = $customerMergeInto->cussno;
                $webuser->save(false);
                yield $log;
            }

            $workorders = Workorder::model()->findAll(array('condition' => "cus_fref = '{$customer->cuscus_fref}'"));
            foreach ($workorders as $workorder) {
                $log = "Customer reference of the sales order [{$workorder->id}][{$workorder->salesorderNumber}] has been updated to [{$customerMergeInto->cuscus_fref}] from [{$workorder->cus_fref}]";
                $workorder->cus_fref = $customerMergeInto->cuscus_fref;
                $workorder->save(false);
                yield $log;
            }
        }
    }
    
    
    public static function OfCustomer($forCustomers, $toCustomer) {
        foreach (self::updateCustomerReferences($forCustomers, $toCustomer) as $log) {
            self::$logs[] = $log;
        }
        
        return self::$logs;
    }

}
