<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity
{
	/**
	 * Authenticates a user.
	 * The example implementation makes sure if the username and password
	 * are both 'demo'.
	 * In practical applications, this should be changed to authenticate
	 * against some persistent user identity storage (e.g. database).
	 * @return boolean whether authentication succeeds.
	 */
		
	private $_id;
	
    public function authenticate()
    {
    	$user_model = new User;
    	//$test_model = new UserProfile;
    	//echo $test_model->test();
    	
        $record=$user_model->findByAttributes(array('username'=>$this->username));
        
        if ($record !== null)
        {
        	$user_model->password=$record->password;
        }
        
        if($record===null)
        {
            $this->errorCode=self::ERROR_USERNAME_INVALID;
        }
        else if($user_model->password!== md5($this->password))
        {
            $this->errorCode=self::ERROR_PASSWORD_INVALID;
        }
        else
        {
            $this->_id=$record->id;
            $this->setState('title', $record->title);
            $this->setState('username', $record->username);
            $this->setState('email', $record->email);
            $this->errorCode=self::ERROR_NONE;
        }
        return !$this->errorCode;
    }
 
    public function getId()
    {
        return $this->_id;
    }
}