<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of XeroAPI
 *
 * @author Eranga
 */
require 'vendor/autoload.php';

use XeroAPI\XeroPHP\AccountingObjectSerializer;

class XeroAPI {

    public static function getApiInstance() {


        $storage = new StorageClass();
        $xeroTenantId = (string) $storage->getSession()['tenant_id'];

        if ($storage->getHasExpired()) {
            $provider = new \League\OAuth2\Client\Provider\GenericProvider(XeroSetting::getGenericProviderOptions());

            $newAccessToken = $provider->getAccessToken('refresh_token', [
                'refresh_token' => $storage->getRefreshToken()
            ]);

            // Save my token, expiration and refresh token
            $storage->setToken(
                    $newAccessToken->getToken(), $newAccessToken->getExpires(), $xeroTenantId, $newAccessToken->getRefreshToken(), $newAccessToken->getValues()["id_token"]);
        }

        $config = XeroAPI\XeroPHP\Configuration::getDefaultConfiguration()->setAccessToken((string) $storage->getSession()['token']);
        $config->setHost("https://api.xero.com/api.xro/2.0");

        return new XeroAPI\XeroPHP\Api\AccountingApi(
                new GuzzleHttp\Client(), $config
        );
    }

}
