<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of XeroInvoiceApi
 *
 * @author rajaera@gmail.com
 */
require 'vendor/autoload.php';

use XeroAPI\XeroPHP\AccountingObjectSerializer;

class XeroInvoiceApi {

    protected $apiInstance;
    protected $errorMessage;

    //inject dependency api
    public function __construct($apiInstance) {
        $this->apiInstance = $apiInstance;
    }

    /**
     * @return array XeroAPI\XeroPHP\Models\Accounting\Address objects
     */
    protected function getAddresses($model) {
        $masterCustomer = $model->job->customer->master;
        $addresses = [];
        $address = new XeroAPI\XeroPHP\Models\Accounting\Address;
        $address->setAddressType('POBOX');
        $address->setAddressLine1($masterCustomer->mcusadd1);
        $address->setAddressLine2($masterCustomer->mcusadd2);
        $address->setAddressLine3($masterCustomer->mcusadd3);
        $address->setCity($masterCustomer->mcustown);
        $address->setRegion($masterCustomer->mcusstate);
        $address->setPostalCode($masterCustomer->mcuspostcode);

        array_push($addresses, $address);

        return $addresses;
    }

    /**
     * @return array XeroAPI\XeroPHP\Models\Accounting\Phone objects
     */
    protected function getPhones($model) {
        $masterCustomer = $model->job->customer->master;
        $phones = [];
        $phone = new XeroAPI\XeroPHP\Models\Accounting\Phone;
        $phone->setPhoneType('DEFAULT');
        $phone->setPhoneNumber($masterCustomer->mcustel);
        array_push($phones, $phone);

//		$phone2 = new XeroAPI\XeroPHP\Models\Accounting\Phone;
//		$phone2->setPhoneType('MOBILE');
//		$phone2->setPhoneNumber($masterCustomer->cusmobtel);
//
//		array_push($phones, $phone2);

        $phone3 = new XeroAPI\XeroPHP\Models\Accounting\Phone;
        $phone3->setPhoneType('FAX');
        $phone3->setPhoneNumber($masterCustomer->mcusfax);

        array_push($phones, $phone3);

        return $phones;
    }

    /**
     * @return XeroAPI\XeroPHP\Models\Accounting\Contact object
     */
    public function getContact($model) {
        $masterCustomer = $model->job->customer->master;
        //get Xero address objects array
        $addresses = $this->getAddresses($model);
        //get Xero phone objects array
        $phones = $this->getPhones($model);

        $contact = new XeroAPI\XeroPHP\Models\Accounting\Contact;
        if (trim($masterCustomer->xeroContactID)) {
            $contact->setContactId($masterCustomer->xeroContactID);
        }

        //if there is no xero id for contact, it stll be available in Xero by name - so find and update the contact local xero id - otherwise xero api exception will throw
        if (!trim($masterCustomer->xeroContactID)) {
            $xeroApiInstance = XeroAPI::getApiInstance();


            //pull master customer contact and update the local xero id
            $storage = new StorageClass();
            $xeroTenantId = (string) $storage->getSession()['tenant_id'];

            $xeroContacts = $xeroApiInstance->getContacts($xeroTenantId, null, "Name={$masterCustomer->mcusnam}", null, null, null, null);

            if (isset($xeroContacts->getContacts()[0]) && $xeroContact = $xeroContacts->getContacts()[0]) {
                $masterCustomer->xeroContactID = $xeroContact->getContactId();
                if ($masterCustomer->save(false)) {
                    $contact->setContactId($masterCustomer->xeroContactID);
                }
            }
        }


        $contact->setName($masterCustomer->mcusnam);
        $contact->setAddresses($addresses);
        $contact->setEmailAddress($masterCustomer->mcusemail);
        $contact->setPhones($phones);
        $contact->setIsCustomer(true);

        return $contact;
    }

    /**
     * @return array XeroAPI\XeroPHP\Models\Accounting\LineItem objects
     */
    protected function getLineItems($model) {
        $lineItems = [];

        $modelDetial = InvoiceDetail::model()->findAll(array('condition' => "invoice_id = '{$model->id}'"));
        foreach ($modelDetial as $dtl) {
            $workorderdtl = $dtl->workorderdtl;
            $itmQty = $workorderdtl->prodQty;
            $accountCode = 200; //sales default
            if ($xeroAccount = XeroAccount::model()->findByPk($dtl->xero_account_id)) {
                $accountCode = $xeroAccount->code;
            }

            /* --------Product Item -------------- */

            $decription = $workorderdtl->productsku . "\n" . $workorderdtl->prdsrtdesc . "\n" . $workorderdtl->getMultiDecoDetailsHtmlExLink();



            $lineItem = new XeroAPI\XeroPHP\Models\Accounting\LineItem;
            $lineItem->setDescription($decription);
            $lineItem->setQuantity($itmQty);
            $lineItem->setUnitAmount($dtl->sellPriceExVat);
            $lineItem->setLineAmount(($dtl->sellPriceExVat * $itmQty));
            $lineItem->setAccountCode($accountCode);

            array_push($lineItems, $lineItem);
        }

        return $lineItems;
    }

    /**
     * @return XeroAPI\XeroPHP\Models\Accounting\Invoice object
     */
    public function getInvoice($model) {

        // get Xero contact object
        $contact = $this->getContact($model);

        $invoice = new XeroAPI\XeroPHP\Models\Accounting\Invoice;
        $invoice->setInvoiceNumber($model->invoiceNum);
        $invoice->setStatus('DRAFT');
        $invoice->setReference($model->job->jobNum);
        $invoice->setType('ACCREC');
        $dateObj = new DateTime($model->createdDtm);
        $dateObj->format('Y-m-d');
        $invoice->setDate($dateObj);
        $dueDateObj = new DateTime($model->duedate);
        $dueDateObj->format('Y-m-d');
        $invoice->setDueDate($dueDateObj);
        $invoice->setLineAmountTypes('Exclusive');

        $invoice->setContact($contact);

        $invoice->setLineItems($this->getLineItems($model));

        return $invoice;
    }

    public function updateXero($xeroInvoiceId, XeroAPI\XeroPHP\Models\Accounting\Invoice $invoice) {
        try {

            $storage = new StorageClass();
            $xeroTenantId = (string) $storage->getSession()['tenant_id'];

            return $this->apiInstance->updateInvoice($xeroTenantId, $xeroInvoiceId, $invoice);
        } catch (\XeroAPI\XeroPHP\ApiException $e) {


            $errorMessage = json_encode($e->getMessage(), true);

            $this->errorMessage = "ApiException - " . $errorMessage;
            return false;
        }
    }

    public function createXero(XeroAPI\XeroPHP\Models\Accounting\Invoice $invoice) {
        try {

            $storage = new StorageClass();
            $xeroTenantId = (string) $storage->getSession()['tenant_id'];

            $apiResponse = $this->apiInstance->createInvoice($xeroTenantId, $invoice);
            return $apiResponse->getInvoices()[0]->getInvoiceId();
        } catch (\XeroAPI\XeroPHP\ApiException $e) {

            $errorMessage = json_encode($e->getMessage(), true);
            $this->errorMessage = "ApiException - " . $errorMessage;

            return false;
        }
    }

    public function getErrorMessage() {
        return $this->errorMessage;
    }

}
