<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of XeroPurchaseOrderApi
 *
 * @author rajaera@gmail.com
 */
require 'vendor/autoload.php';

use XeroAPI\XeroPHP\AccountingObjectSerializer;

class XeroPurchaseOrderApi {

    protected $apiInstance;
    protected $errorMessage;

    //inject dependency api
    public function __construct($apiInstance) {
        $this->apiInstance = $apiInstance;
    }

    /**
     * @return array XeroAPI\XeroPHP\Models\Accounting\Address objects
     */
    protected function getAddresses($model) {
        $addresses = [];
        $address = new XeroAPI\XeroPHP\Models\Accounting\Address;
        $address->setAddressType('POBOX');
        $address->setAddressLine1($model->supplier_->supad1);
        $address->setAddressLine2($model->supplier_->supad2);
        $address->setAddressLine3($model->supplier_->supad3);
        $address->setCity($model->supplier_->suptown);
        $address->setRegion($model->supplier_->supstate);
        $address->setPostalCode($model->supplier_->suppostcode);

        array_push($addresses, $address);

        return $addresses;
    }

    /**
     * @return array XeroAPI\XeroPHP\Models\Accounting\Phone objects
     */
    protected function getPhones($model) {

        $phones = [];
        $phone = new XeroAPI\XeroPHP\Models\Accounting\Phone;
        $phone->setPhoneType('DEFAULT');
        $phone->setPhoneNumber($model->supplier_->suptel);
        array_push($phones, $phone);

        $phone3 = new XeroAPI\XeroPHP\Models\Accounting\Phone;
        $phone3->setPhoneType('FAX');
        $phone3->setPhoneNumber($model->supplier_->supfax);

        array_push($phones, $phone3);

        return $phones;
    }

    /**
     * @return XeroAPI\XeroPHP\Models\Accounting\Contact object
     */
    public function getContact($model) {

        $addresses = $this->getAddresses($model);
        //get Xero phone objects array
        $phones = $this->getPhones($model);

        $xeroSupplier = XeroSupplier::model()->find("xeroContactID = '{$model->supplier_->xeroContactID}'");

        if (!$xeroSupplier) {
            $this->errorMessage = 'Cannot find the relationship between Xero supplier and the system supplier!';
            return null;
        }

        $contact = new XeroAPI\XeroPHP\Models\Accounting\Contact;
        if (trim($model->supplier_->xeroContactID)) {
            $contact->setContactId($model->supplier_->xeroContactID);
        }

        /*
          $contact->setName($model->supplier_->supnam);
          $contact->setAddresses($addresses);
          $contact->setEmailAddress($model->supplier_->supemail);
          $contact->setPhones($phones);
          $contact->setIsSupplier(true);
          $contact->setContactNumber($model->supplier_->supsup_fref);
         * 
         */

        return $contact;
    }

    /**
     * @return array XeroAPI\XeroPHP\Models\Accounting\LineItem objects
     */
    protected function getLineItems($model) {
        $lineItems = [];

        if ($model->poType == 'Purchase Product-Decoration') {
            $modelDetial = PurchaseOrderDetails::model()->findAll(array('condition' => "po_id = {$model->id}", 'group' => 'workorderDtl_id'));
        } else {
            $modelDetial = PurchaseOrderDetails::model()->findAll(array('condition' => "po_id = {$model->id}"));
        }

        foreach ($modelDetial as $dtl) {

            $xeroAccount = XeroAccount::model()->findByPk($dtl->xero_account_id);

            if (!$xeroAccount) {
                $xeroAccount = XeroAccount::model()->findByPk(XeroSetting::getSetting()->defalutPOAccountId); //sales default
            }
            $accountCode = $xeroAccount->code;
            $i = 0;
            $record = $dtl->workorderDtl;



            $colorSizeQtyBreakText = '';
            foreach ($record->rel_size_qty_colors() as $breakUp) {
                $colorSizeQtyBreakText .= '<br>[ ' . $breakUp->color . ' - ' . $breakUp->size . ' - ' . $breakUp->qty . ' ]';
            }

            $item_description = trim($record->productsku . ' - ' . strip_tags(nl2br($record->prdsrtdesc))) . ' - ' . strip_tags(nl2br($record->customizationDetails)) . $colorSizeQtyBreakText;

            $productLineItem = new XeroAPI\XeroPHP\Models\Accounting\LineItem;
            $productLineItem->setLineItemId($dtl->xeroLineItemID);
            $productLineItem->setDescription($item_description);
            $productLineItem->setQuantity($record->prodQty);
            $productLineItem->setUnitAmount(round($record->prodCostPrice, 2));
            $productLineItem->setLineAmount(round($record->prodCostPrice * $record->prodQty, 2));
            $productLineItem->setAccountCode($accountCode);

            array_push($lineItems, $productLineItem);



            $jobproddecorations = JobProductDecorations::model()->findAll(array('condition' => "po_id = {$dtl->po_id} and workorderDtl_id = {$dtl->workorderDtl_id}"));
            foreach ($jobproddecorations as $jobprddata) {
                /**
                 * We cannot get outer loop purchase order details directly because of it has been grouped by work order detail id
                 * so we have to find to correct purchaser order details id to get Xero account id through job product decoration model
                 */
                $jobprddecopodtl = PurchaseOrderDetails::model()->findByPk($jobprddata->po_detail_id);
                $xeroDecoAccount = XeroAccount::model()->findByPk($jobprddecopodtl->xero_account_id);

                $workorderDetailsDecoration = WorkorderDetailsDecoration::model()->findByPk($jobprddata->work_order_detail_decoration_id);

                $item_deco_description = trim($jobprddata->decprtnam . ' - ' . strip_tags(nl2br($jobprddata->decdesc))) . ' - ' . strip_tags(nl2br($jobprddata->customizationDetails));

                $decorationLineItem = new XeroAPI\XeroPHP\Models\Accounting\LineItem;
                $decorationLineItem->setLineItemId('');
                $decorationLineItem->setDescription($item_deco_description);
                $decorationLineItem->setQuantity($record->prodQty);
                $decorationLineItem->setUnitAmount(round($jobprddata->decoCostPrice, 2));
                $decorationLineItem->setLineAmount(round($jobprddata->decoCostPrice * $record->prodQty, 2));
                $decorationLineItem->setAccountCode(($xeroDecoAccount ? $xeroDecoAccount->code : $accountCode));

                array_push($lineItems, $decorationLineItem);



                if (!$logoSetup = $jobprddata->logo_setup) {
                    $logoSetup = $workorderDetailsDecoration ? $workorderDetailsDecoration->logo_setup : 0;
                }

                $logosetupLineItem = new XeroAPI\XeroPHP\Models\Accounting\LineItem;
                $logosetupLineItem->setLineItemId('');
                $logosetupLineItem->setDescription('Logo Setup');
                $logosetupLineItem->setQuantity(1);
                $logosetupLineItem->setUnitAmount(round($logoSetup, 2));
                $logosetupLineItem->setLineAmount(round($logoSetup, 2));
                $logosetupLineItem->setAccountCode(($xeroDecoAccount ? $xeroDecoAccount->code : $accountCode));

                array_push($lineItems, $logosetupLineItem);
            }


            $i++;
        }

        return $lineItems;
    }

    /**
     * @return XeroAPI\XeroPHP\Models\Accounting\PurchaseOrder object
     */
    public function getOrder($model) {

        // get Xero contact object
        $contact = $this->getContact($model);

        $po = new XeroAPI\XeroPHP\Models\Accounting\PurchaseOrder;
        $po->setPurchaseOrderNumber($model->poNum);
        $po->setStatus("DRAFT");
        $po->setContact($contact);
        $dateObj = new DateTime($model->createdDtm);
        $dateObj->format('Y-m-d');
        $po->setDate($dateObj);
        $po->setLineAmountTypes('Exclusive');
        $reference = 'PO: ' . ($model->job->customerpono ?: '-') . ' Job:' . $model->job->jobNum;
        $po->setReference($reference);

        $po->setContact($contact);

        $po->setLineItems($this->getLineItems($model));

        return $po;
    }

    public function updateXero($xeroInvoiceId, XeroAPI\XeroPHP\Models\Accounting\PurchaseOrder $purchaseOrder) {
        try {

            $storage = new StorageClass();
            $xeroTenantId = (string) $storage->getSession()['tenant_id'];

            return $this->apiInstance->updatePurchaseOrder($xeroTenantId, $xeroInvoiceId, $purchaseOrder);
        } catch (\XeroAPI\XeroPHP\ApiException $e) {
            $error = AccountingObjectSerializer::deserialize(
                            $e->getResponseBody(), '\XeroAPI\XeroPHP\Models\Accounting\Error', []
            );
            $this->errorMessage = "ApiException - " . $error->getElements()[0]["validation_errors"][0]["message"];
            return false;
        }
    }

    public function createXero(XeroAPI\XeroPHP\Models\Accounting\PurchaseOrder $purchaseOrder) {
        try {
            $storage = new StorageClass();
            $xeroTenantId = (string) $storage->getSession()['tenant_id'];

            $apiResponse = $this->apiInstance->createPurchaseOrder($xeroTenantId, $purchaseOrder);
            return $apiResponse->getPurchaseOrders()[0]->getPurchaseOrderId();
        } catch (\XeroAPI\XeroPHP\ApiException $e) {
            $error = AccountingObjectSerializer::deserialize(
                            $e->getResponseBody(), '\XeroAPI\XeroPHP\Models\Accounting\Error', []
            );
            $this->errorMessage = "ApiException - " . $error->getElements()[0]["validation_errors"][0]["message"];
            return false;
        }
    }

    public function getErrorMessage() {
        return $this->errorMessage;
    }

}
