<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ArtworkEmailTemplateTextFromatter
 *
 * @author Eranga
 */
class ArtworkEmailTemplateTextFromatter extends TemplateTextFormatter {
    private $artworkJob;
    
    public function __construct(JobArtwork $model) {
        $this->artworkJob = $model;
    }
    
    public function format(string $text_contents) {
        
        $placeholders = ["ARTWORK_NUMBER", "ONLINE_ACCEPTANCE_LINK", "JOB_NUMBER"];
        $replacers = [];
        $replacers[] = $this->artworkJob->artworkjobNum;
        //generate online acceptance link and format
        $this->artworkJob->generateOnlineAcceptLink(); 
        $replacers[] = "<a "
                . "href='{$this->artworkJob->onlineAcceptenceLog->accept_url}'"
                . "data-mce-href='{$this->artworkJob->onlineAcceptenceLog->accept_url}'>"//'data-mce-href' required for TINY text editor, otherwise 'href' attribute will be replaced by URL without domain name
                . "{$this->artworkJob->onlineAcceptenceLog->accept_url}</a>";      
        $replacers[] = ucwords($this->artworkJob->job->jobNum);

        return str_replace($placeholders, $replacers, $text_contents);
    }
}
