<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Manage curl calls
 *
 * @author Eranga Perera <rajaera@gmail.com>
 */
class CurlCall
{
	/**
	 * @var CurlHeader curl heaeder parameter class
	 */
	protected $curlHeader;
	protected $RESPONSE_CODE;
	
	public function __construct(CurlHeader $curlHeader)
	{
		$this->curlHeader = $curlHeader;
	}
	
	
	final public function curlGet($requestURL){
		
		$session = curl_init($requestURL);
        curl_setopt($session, CURLOPT_HTTPHEADER, $this->curlHeader->headers());
        curl_setopt($session, CURLOPT_HEADER, false);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, true);
		
        // get the response & close the session
        $response = curl_exec($session);
		$this->RESPONSE_CODE = curl_getinfo($session, CURLINFO_HTTP_CODE);
        curl_close($session);
       
        return $response;
	}
	
	final public function curlPost($requestURL, $postFields){	
		
        $session = curl_init($requestURL);

        curl_setopt($session, CURLOPT_HTTPHEADER, $this->curlHeader->headers()); //load all header data
		
        curl_setopt($session, CURLOPT_POST, true); //comment out this PUT line to change to a POST statement        
		//curl_setopt($session, CURLOPT_USERPWD, '' . ':' . '');
        curl_setopt($session, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($session, CURLOPT_POSTFIELDS, $postFields);
        curl_setopt($session, CURLOPT_SSL_VERIFYHOST, true);
		curl_setopt($session, CURLOPT_HEADER, false);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, true); 
		
        $response = curl_exec($session);
		$this->RESPONSE_CODE = curl_getinfo($session, CURLINFO_HTTP_CODE);
        curl_close($session);
		
		

        return $response;
	}
	
	/**
	 * @param CurlHeader $curlHeader set curl header
	 * @return void
	 */
	public function setHeader(CurlHeader $curlHeader)
	{
		$this->curlHeader = $curlHeader;
	}
	/**
	 * @return integer http response code
	 */
	public function getResponseCode()
	{
		return $this->RESPONSE_CODE;
	}
	
}
