<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of CurlHeaderIfModifiedContact
 *
 * @author User
 */
class CurlHeaderIfModifiedContact extends CurlHeader
{
	/**
	 * @var string i.e. date format : Fri, 21 Mar 2014 02:51:32 GMT
	 */
	private $ifModifiedSince;
	protected $auth;
	protected $setting;

	/**
	 * @param string $ifModifiedSince date format should be in: Fri, 21 Mar 2014 02:51:32 GMT
	 */
	public function __construct(MYOBAuth $auth,$ifModifiedSince)
	{
		$this->auth = $auth;
		
		$this->ifModifiedSince = $ifModifiedSince;
	}
	
	
	public function headers()
	{
		 return array(
            'Authorization: Bearer ' . $this->auth->getToken()->access_token,         
            'x-myobapi-key: '. $this->auth->getSetting()->api_key,
            'x-myobapi-version: v2',
			'If-Modified-Since: ' . $this->ifModifiedSince,
            'Content-Type: application/json'
        );
	}

}
