<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of GwsProductApi
 *
 * @author Eranga
 */
class GwsProductApi {

    protected $postFields;
    protected $rawData;
    protected static $api_response;

    public function __construct() {
        
    }

    public static function getDefaultPostFields() {
        $systemOptions = SystemOptions::getOptions();
        $postFields = array(
            "user" => array(
                //"username" => "POGwSapiDev",
               // "password" => "dS~jKu:Qjfkg>Lyp@n2[Q~&t#ABck%Be"

             "username" => trim($systemOptions->gwsApiUsername),
            "password" => trim($systemOptions->gwsApiPassword)
            ),
            "data" => array(
                "supplier_mps" => "",
                "product_code" => "",
                "product_Name" => "",
                "category" => ""
            )
        );

        return $postFields;
    }

    public static function dataProvider($postFields) {
        $systemOptions = SystemOptions::getOptions();
        $requestURL = trim($systemOptions->gwsApiRequestUrl);
        

        $curlCall = new CurlCall(new CurlHeaderJson());
        $curlResponse = $curlCall->curlPost($requestURL, json_encode($postFields));
       
        $result_arr = json_decode($curlResponse, true);
        self::$api_response = $result_arr;

        $rawData = is_array($result_arr) && isset($result_arr['data'][0]) ? $result_arr['data'][0] : array();



        /*
          // Create filter model and set properties
          $rawDatafiltersForm = new GwsProductApiRawDataFilterForm;
          if (isset($_GET['GwsProductApiRawDataFilterForm']))
          $rawDatafiltersForm->filters = $_GET['GwsProductApiRawDataFilterForm'];

          $filteredData = $rawDatafiltersForm->filter($rawData);
         * 
         */



        $dataProvider = new CArrayDataProvider($rawData, array(
            'id' => 'product-api',
            'keyField' => 'pro_code',
            'sort' => array(
                'attributes' => array(
                    'id', 'supplier', 'pro_code',
                ),
            ),
            'pagination' => array(
                'pageSize' => 10,
            ),
        ));

        return $dataProvider;
    }
    
    public static function getApiResponse() {
        return self::$api_response;
    }

    public static function productData($postFields) {

        $systemOptions = SystemOptions::getOptions();
        $requestURL = trim($systemOptions->gwsApiRequestUrl);

        $curlCall = new CurlCall(new CurlHeaderJson());

        $result_arr = json_decode($curlCall->curlPost($requestURL, json_encode($postFields)), true);

        $rawData = $result_arr['data'][0] ?: array();

        return $rawData;
    }

    public static function extractPriceBreaksIntoTable($data) {
        $html = '';
        if (isset($data["price"])) {

            foreach ($data["price"] as $index => $priceBreakArr) {

                $html .= "<table><caption>Price Look-Up Set - {$priceBreakArr['set']}</caption>";
                //header line which represent quanity
                $html .= '<tr>';

                foreach ($priceBreakArr as $key => $value) {

                    if (strpos($key, 'q') !== false && $value) {

                        $html .= "<td>{$value}</td>";
                    }
                }
                $html .= '</tr>';
                //base line which represent prices
                $html .= '<tr>';
                foreach ($priceBreakArr as $key => $value) {

                    if (strpos($key, 'p') !== false && $value) {
                        $html .= "<td>{$value}</td>";
                    }
                }
                $html .= '</tr>';
                $html .= '</table>';
            }
        }

        return $html;
    }
    
    public static function extractPriceBreaksIntoTableRows($data) {
        $html = '';
        if (isset($data["price"])) {

            foreach ($data["price"] as $index => $priceBreakArr) {

                
                //header line which represent quanity
                $html .= '<tr>';

                foreach ($priceBreakArr as $key => $value) {

                    if (strpos($key, 'q') !== false && $value) {

                        $html .= "<td>{$value}</td>";
                    }
                }
                $html .= '</tr>';
                //base line which represent prices
                $html .= '<tr>';
                foreach ($priceBreakArr as $key => $value) {

                    if (strpos($key, 'p') !== false && $value) {
                        $html .= "<td>{$value}</td>";
                    }
                }
                $html .= '</tr>';
                
            }
        }

        return $html;
    }

    public static function getImage($data) {
        $imagefile = self::getImageFile($data);




        if (strpos($imagefile, 'http:') !== false || strpos($imagefile, 'https:') !== false) {

            return Chtml::image($imagefile, "", array());
        } else {

            return Chtml::image(GlobalVars::get(GlobalVars::PRODUCT_IMAGE_SOURCE) . $data["supplier_mps"] . "/" . $imagefile, "", array());
        }

        return '';
    }

    public static function getImageFile($data) {
        $imagefile = '';


        if (isset($data['image1']) && $data['image1']) {
            $imagefile = $data['image1'];
        } else if (isset($data['image2']) && $data['image2']) {
            $imagefile = $data['image2'];
        } else if (isset($data['image3']) && $data['image3']) {
            $imagefile = $data['image3'];
        }

        if (!$imagefile) {
            return '';
        }

        if (strpos($imagefile, 'http:') !== false || strpos($imagefile, 'https:') !== false) {

            return $imagefile;
        } else {

            return GlobalVars::get(GlobalVars::PRODUCT_IMAGE_SOURCE) . $data["supplier_mps"] . "/" . $imagefile;
        }
    }

}
