<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of MYOBAccountReferenceFinder
 *
 * @author User
 */
class MYOBAccountReferenceFinder implements MYOBReferenceFinder
{
	/**
	 * Check the given active record in MYOB	 * 
	 */
	public function hasRecord(\MYOBApiConnector $myobConnector, \CActiveRecord $activeRecord)
	{

		
		if ($activeRecord->uuid) {

			$myobConnector->setURLEndPoint('GeneralLedger/Account/' . $activeRecord->uuid);
			$response = $myobConnector->apiGet(); /* if success apiGet returns array of MYOBResponse objects */
			if ($myobConnector->getCurlResponseCode() == 200 && $response[0]) {
				return $response[0];
			}
		}
		/* if the local record doesn't have myob references search by other references */
		$myobConnector->setURLEndPoint('GeneralLedger/Account/');
		$myobConnector->setODataFilter(
				'Name eq \'' . $activeRecord->name . '\' and '
				. 'DisplayID eq \'' . $activeRecord->displayId . '\' and '
				. 'Classification eq \'' . $activeRecord->classification . '\' and '
				. 'Type eq \'' . $activeRecord->Type . '\''
				);
		$response = $myobConnector->apiGet();
		
		if ($myobConnector->getCurlResponseCode() == 200 && $response[0]) {
			return $response[0];
		} else {
			return false;
		}
	}

	/**
	 * Check the given MYOB record in local database
	 * @return mixed the first row (in terms of an array which has only cussno as id) of the query result, false if no result.
	 */
	public function hasRecordInLocal(\MYOBResponse $myobResponse)
	{
		return Yii::app()->db->createCommand()
				->select('id')
				->from('myob_accounts')
				->where(
						'(uuid=:UID AND myob_guid_uuid=:GUID) OR (name=:NAME AND displayId=:DISPLAYID AND classification=:CLASSIFY AND type=:TYPE)', 
						array(
							':UID' => $myobResponse->UID,
							':GUID' => Yii::app()->session['myob_guid'],
							':NAME' => $myobResponse->Name,	
							':DISPLAYID' => $myobResponse->DisplayID,
							':CLASSIFY' => $myobResponse->Classification,
							':TYPE' => $myobResponse->Type,
							)
						)
				->queryRow();		
	}

}
