<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * MYOBApiConnector builds the connection with MYOB API while allowing user to get and post requests
 * against the API. 
 *
 * @author Eranga Perera <rajaera@gmail.com>
 */
class MYOBApiConnector
{
	/**
	 *@var string API base URL constant 
	 */
	const API_BASE_URL = 'https://api.myob.com/accountright/';
	/**
	 * @var CurlResponseGenerator generate object array by curl response
	 */
	protected $curlResponseGenerator;
	
	/**
	 * @var CurlCall calling to api via curl
	 */
	protected $curlCall;
	/**
	 *@var integer http response code
	 */
	protected $curlResponseCode;
	/**
	 * @var string api end point URL with optional query parameters
	 * i.e. Contact/Customer/ or Contact/Customer/?$filter=DisplayID+eq+'CUS000001'
	 */
	protected $urlEndPoint;	
	/**
	 *OData-supported query string filters
	 * @var string will be encoded 
	 */
	protected $oDataFilter;
	
	/**
	 * MYOB auth access granter
	 * @var MYOBAuth
	 */
	protected $auth;


	public function __construct(MYOBAuth $auth)
	{	
		$this->auth = $auth;
		
		if ((int)$auth->getSetting()->environment === MyobSetting::ENVIRONMENT_SANDBOX_ACCOUNT) {
			/*for the development purpose */
			$this->curlCall = new CurlCall(new CurlHeaderSandBoxAccount($auth));	
		} elseif ((int)$auth->getSetting()->environment === MyobSetting::ENVIRONMENT_LIVE_ACCOUNT) {
			$this->curlCall = new CurlCall(new CurlHeaderLiveAccount($auth));	
		} else {
			throw new Exception('Undefined Account Environment!');
		}		
			
		
		$this->curlResponseGenerator = new MYOBResponseGenerator();		
	}	
	
	/**
	 * 
	 * @return string full URL for API request get
	 */
	public function requestedURLGet()
	{
		return self::API_BASE_URL . $this->auth->getGuide()->uuid . DIRECTORY_SEPARATOR . $this->urlEndPoint . ($this->oDataFilter?'?$filter='. urlencode($this->oDataFilter):'');
	}
	
	/**
	 * 
	 * @return string full URL for API request post
	 */
	public function requestedURLPost()
	{
		return self::API_BASE_URL . $this->auth->getGuide()->uuid . DIRECTORY_SEPARATOR . $this->urlEndPoint;
	}

	/**
	 * @param CurlHeader $curlHeadear a concrete implementation of CurlHeader
	 * @return array Array of MYOBResponse objects
	 */
	final public function apiGet(CurlHeader $curlHeadear = null, $requestUrl = null)
	{
		
		
		if ($curlHeadear) {
			$this->curlCall->setHeader($curlHeadear);
		}
		/* tested upto here */
		/* Bad request error throws in following line */
		
		$curlResponse = $this->curlCall->curlGet($requestUrl?:$this->requestedURLGet());
		
		$this->curlResponseCode = $this->curlCall->getResponseCode();		
		//var_dump($curlResponse);		exit();
		if (json_decode($curlResponse,true)) { /* check a json object array has been received as response */
			
			return $this->curlResponseGenerator->generate($curlResponse);			
		}
		
		return null;		
	}
	/**
	 * @param string $jsonString json encoded string
	 * @return array Array of MYOBResponse objects
	 */
	final public function apiPost($jsonString, CurlHeader $curlHeadear = null)
	{
		if ($curlHeadear) {
			$this->curlCall->setHeader($curlHeadear);
		}
		$curlResponse = $this->curlCall->curlPost($this->requestedURLPost(), $jsonString);
		$this->curlResponseCode = $this->curlCall->getResponseCode();	
		
		if (json_decode($curlResponse, true)) { /* check an json object array has been received as response */
			
			return $this->curlResponseGenerator->generate($curlResponse);
		}
		
		return null;
	}
	
	/**
	 * @param string $urlEndPoint api end point URL with optional query parameters
	 * i.e. Contact/Customer/ or Contact/Customer/?$filter=DisplayID+eq+'CUS000001'
	 * @return void
	 */
	public function setURLEndPoint($urlEndPoint)
	{
		$this->urlEndPoint = $urlEndPoint;
	}
	
	public function setODataFilter($oDataFilter)
	{
		$this->oDataFilter = $oDataFilter;
	}
	
	
	public function getCurlResponseCode()
	{
		return $this->curlResponseCode;
	}
	
	/**
	 * @return MYOBAuth
	 */
	public function getAuth()
	{
		return $this->auth;
	}
	
	public function resetURL()
	{
		$this->urlEndPoint = '';
		$this->oDataFilter = '';
	}
	
	
}
