<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of MYOBItemReferenceFinder
 *
 * @author User
 */
class MYOBItemReferenceFinder implements MYOBReferenceFinder
{

	/**
	 * Check the given active record is available in MYOB	 * 
	 */
	public function hasRecord(\MYOBApiConnector $myobConnector, \CActiveRecord $activeRecord)
	{

		
		if ($activeRecord->myob_uuid) {

			$myobConnector->setURLEndPoint('Inventory/Item/' . $activeRecord->myob_uuid);
			$response = $myobConnector->apiGet(); /* if success apiGet returns array of MYOBResponse objects */
			if ($myobConnector->getCurlResponseCode() == 200 && $response[0]) {
				return $response[0];
			} 
		}
		/* if the local record doesn't have myob references or cannot find in MYOB then search by other references */
		/* Don't filter items by name in MYOB, it can be duplicated */
		$myobConnector->setURLEndPoint('Inventory/Item/');
		$myobConnector->setODataFilter('Number eq \'' . trim($activeRecord->pdlsno) . '\'');
		$response = $myobConnector->apiGet();

		if ($myobConnector->getCurlResponseCode() == 200 && $response[0]) {
			return $response[0];
		} else {
			return false;
		}
	}

	/**
	 * Check the given MYOB record in local database
	 * @return mixed the first row (in terms of an array which has only cussno as id) of the query result, false if no result.
	 */
	public function hasRecordInLocal(\MYOBResponse $myobResponse)
	{
		/* Don't check items by name in product_line table, it can be duplicated */
		return Yii::app()->db->createCommand()
				->select('pdlsno as id')
				->from('product_line')
				->where(
						'TRIM(pdlpdl)=:Number', 
						array(							
							':Number' => trim($myobResponse->Number)
							)
						)
				->queryRow();		
	}

}
