<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * All codes to delete all MYOB related data including MYOB supplier, accounts and tax codes. Also this will wipe out the MYOB relations of products, customers, invoices, purchase orders etc.
 *
 * @author User
 */
class MYOBLocalReset
{
	public static $error;

	public static function doReset()
	{
		$transaction = Yii::app()->db->beginTransaction();
		try {
			//clear myob related table			
			$tableNameArr = array('myob_accounts', 'myob_guids', 'myob_log', 'myob_supplier', 'myob_tax_codes', 'myob_tokens');
			foreach ($tableNameArr as $table) {
				$sql = "TRUNCATE TABLE {$table};";
				$sqlComnd = Yii::app()->db->createCommand($sql);
				$sqlComnd->execute();
			}

			//clear myob data in customer
			$sqlc = "UPDATE customer SET myob_uuid = NULL, json_response = NULL, myob_row_version = NULL, myob_taxId = NULL, myob_freightTaxId = NULL, myob_guid_uuid = NULL, myob_item_price_level = NULL, myob_link = NULL, myob_reference = NULL WHERE cussno > 0;";
			$sqlcComnd = Yii::app()->db->createCommand($sqlc);
			$sqlcComnd->execute();
			
			//clear myob data in invoice
			$sqlInv = "UPDATE invoices SET json_response = NULL, myob_uuid = NULL, myob_row_version = NULL, myobTaxCodeId = NULL, myob_guid_uuid = NULL WHERE id > 0;";
			$sqlInvComnd = Yii::app()->db->createCommand($sqlInv);
			$sqlInvComnd->execute();
			
			//clear myob data in master customer
			$sqlMasCus = "UPDATE master_customer SET myob_uuid = NULL, json_response = NULL, myob_row_version = NULL, myob_taxId = NULL, myob_freightTaxId = NULL, myob_tax_uuid = NULL, myob_freightTax_uuid = NULL, isIndividualMYOB = NULL, displayIdMYOB = NULL, myob_guid_uuid = NULL WHERE mcussno > 0;";
			$sqlMasCusComnd = Yii::app()->db->createCommand($sqlMasCus);
			$sqlMasCusComnd->execute();

			//clear myob data in product line
			$sqlProd = "UPDATE product_line SET json_response = NULL, myob_uuid = NULL, myob_row_version = NULL, myobExpsAccntId = NULL, myobIncmAccntId = NULL, myobBuyingDtlTaxCodeId = NULL, myobSellingDtlTaxCodeId = NULL, myob_guid_uuid = NULL, myobAssetAccId = NULL WHERE pdlsno > 0;";
			$sqlProdComnd = Yii::app()->db->createCommand($sqlProd);
			$sqlProdComnd->execute();
			
			//clear myob data in purchase orders
			$sqlPO = "UPDATE purchase_orders SET json_response = NULL, myob_uuid = NULL, myob_row_version = NULL, myob_guid_uuid = NULL, myobTaxCodeId = NULL, myobFreightTaxCodeId = NULL WHERE id > 0;";
			$sqlPOComnd = Yii::app()->db->createCommand($sqlPO);
			$sqlPOComnd->execute();
			
			//clear myob data in supplier
			$sqlSup = "UPDATE supplier SET myob_uuid = NULL, json_response = NULL, myob_row_version = NULL, myobTaxCodeId = NULL, myobFreightTaxCodeId = NULL, myobExpsAccntId = NULL, myob_guid_uuid = NULL, myob_supplier_id = NULL WHERE supsno > 0;";
			$sqlSupComnd = Yii::app()->db->createCommand($sqlSup);
			$sqlSupComnd->execute();


			$transaction->commit();
			return true;
		} catch (Exception $ex) {
			self::$error = $ex->getMessage();
			$transaction->rollBack();
			return false;
		}
	}

}
