<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of MYOBResponse
 *
 * @author Eranga Perera <rajaera@gmail.com>
 */
class MYOBResponse
{
	const MYOB_API_URL_ERROR_MESSAGES = 'https://developer.myob.com/api/accountright/api-overview/error-messages/';

	static protected $errorTemplate = "<p class='well'><span class='label label-important'> MYOB Error</span><br />{errorMessage}</p>";
	static protected $successTemplate = "<p class='well'><span class='label' style='background-color:green;'> MYOB Success</span><br />{successMessage}</p>";
	public function __construct(array $responseObjArr)
	{
				
		$this->setProperties($responseObjArr);		
	}
	
	static public function formatError(MYOBResponse $response)
	{		
		if (!$response) {
			return '';
		}
		$error = '';
		$error .= 'Name : '.$response->Name.'<br />';
		$error .= 'Message : '.$response->Message.'<br />';
		$error .= 'AdditionalDetails : '.$response->AdditionalDetails.'<br />';
		$error .= 'ErrorCode : '.$response->ErrorCode.'<br />';
		$error .= 'LearnMore : '. ($response->LearnMore?:CHtml::link('API Error Messages & Warnings', self::MYOB_API_URL_ERROR_MESSAGES, array( 'target'=>'_blank'))).'<br />';
		
		return strtr(self::$errorTemplate,  array("{errorMessage}" => $error));
				
	}
	
	static public function formatSuccess(MYOBResponse $response)
	{		
		if (!$response) {
			return '';
		}
		$success = '';
		$success .= 'Name : '.$response->Name.'<br />';
		$success .= 'Message : '.$response->Message.'<br />';
		
		
		return strtr(self::$successTemplate,  array("{successMessage}" => $success));
				
	}
	

	/**
	 * set $this properties dynamically based on the response object 
	 *@param array $responseObjArr individual array object from curl response
	 */
	private function setProperties($responseObjArr)
	{
		foreach ($responseObjArr as $k => $v) {
			$this->{$k} = $v;
		}
	}
	

}
