<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of MYOBResponseGenerator
 *
 * @author User
 */
class MYOBResponseGenerator implements CurlResponseGenerator
{
	/**
	 * Generate MYOBResponse objects array.
	 * if response received with multiple items and MYOB property "NextPageLink" is not null then it will be added to the end of MYOBResponse objects array.
	 * So it's required to check the type of value
	 * @param array $curlResponse response from curl. expected array
	 * @return array array of MYOBResponse objects or null, 
	 */
	public function generate($curlResponse)
	{
		$curlResponseDecoded = json_decode($curlResponse,true);
		
		
		
		if (is_array($curlResponseDecoded) && $curlResponseDecoded) { /* check curl response is an array and not empty */
			
			if (isset($curlResponseDecoded["UID"])) { /*one record has received*/
				
				return call_user_func_array(array($this, 'createMYOBResponses'), array(array($curlResponseDecoded)));
				
			} elseif (isset($curlResponseDecoded["Items"]) && $curlResponseDecoded["Count"]) { /*MYOB API may response with empty 'Items' object for multi records*/				
				
				$myobResponses = call_user_func_array(array($this, 'createMYOBResponses'), array($curlResponseDecoded["Items"]));
				if (isset($curlResponseDecoded["NextPageLink"])) {
					$myobResponses["NextPageLink"] = $curlResponseDecoded["NextPageLink"];
					$myobResponses["Count"] = $curlResponseDecoded["Count"];
				}
				
				return $myobResponses;
			} elseif (isset($curlResponseDecoded["Errors"])) {
				
				$myobResponses = call_user_func_array(array($this, 'createMYOBResponses'), array($curlResponseDecoded["Errors"]));
				$myobResponses["Errors"] = true;
				return $myobResponses;
			} 		
		} 
		return null;
	}

	/**
	 * create array of MYOBResponse objects based on given response type and response data
	 * 
	 * @param integer $responseType type of the response object
	 * @param array $responseArr
	 * @return array Array of MYOBResponse objects
	 */
	protected function createMYOBResponses($responseArr)
	{
		$generatedArr = array();
		foreach ($responseArr as $obj) {
			$generatedArr[] = new MYOBResponse($obj);
		}
		
		return $generatedArr;
	}

}
