<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of MYOBSupplierReferenceFinder
 *
 * @author User
 */
class MYOBSupplierReferenceFinder implements MYOBReferenceFinder
{

	/**
	 * Check the given active record in MYOB	 * 
	 */
	public function hasRecord(\MYOBApiConnector $myobConnector, \CActiveRecord $activeRecord)
	{

		
		if ($activeRecord->myob_uuid) {

			$myobConnector->setURLEndPoint('Contact/Supplier/' . $activeRecord->myob_uuid);
			$response = $myobConnector->apiGet(); /* if success apiGet returns array of MYOBResponse objects */
			if ($myobConnector->getCurlResponseCode() == 200 && $response[0]) {
				return $response[0];
			}
		}
		/* if the local record doesn't have myob references search by other references */
		$myobConnector->setURLEndPoint('Contact/Supplier/');
		$myobConnector->setODataFilter('DisplayID eq \'' . $activeRecord->supsup . '\'');
		$response = $myobConnector->apiGet();

		if ($myobConnector->getCurlResponseCode() == 200 && $response[0]) {
			return $response[0];
		} else {
			return false;
		}
	}

	/**
	 * Check the given MYOB record in local database
	 * @return mixed the first row (in terms of an array which has only cussno as id) of the query result, false if no result.
	 */
	public function hasRecordInLocal(\MYOBResponse $myobResponse)
	{
		return Yii::app()->db->createCommand()
				->select('supsno as id')
				->from('myob_supplier')
				->where(
						'(myob_uuid=:UID AND myob_guid_uuid=:GUID) OR supsup=:DisplayID', 
						array(
							':UID' => $myobResponse->UID,
							':GUID' =>  trim(Yii::app()->session['myob_guid_uuid']),
							':DisplayID' => $myobResponse->DisplayID							
							)
						)
				->queryRow();		
	}

}
