<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Models which implements this interface will be able to be uploaded and upgraded by MYOB api
 *  Refresh a model against the MYOB api. 
 *  check with your own logics to confirm record is available in MYOB 
 * if not available upload the data and save the local record with MYOB data (guid, uuid and row version)
 * @author Eranga Perera <rajaera@gmail.com>
 */
interface MYOBSynchronizable 
{
	/**
	 * Create new record direct from MYOB data
	 * @param MYOBResponse $response
	 * @return boolean
	 * @throws Exception MySql Exception 
	 */
	static function createByMYOB(MYOBResponse $response);
	/**
	 * Synchronize data, call synchronizer
	 * @param MYOBApiConnector $myobConnector 
	 */
	function myobSynchronize(MYOBApiConnector $myobConnector);
	function toJsonString();
	function updateByMYOB(MYOBResponse $response);
	/**
	 * Provided the last updated date time  of particular record
	 * this will help to decide whether it should update local record or MYOB record
	 * @return string datetime (in "Y-m-d H:i:s" format)
	 */
	function myobLastModified();
	function updateMYOBReferences(MYOBResponse $response);
	function setSynchronizer(MYOBSynchronizer $synchronizer);
	function reportMYOBError(MYOBResponse $response);
	function reportMYOBSuccess(MYOBResponse $response);
	function getMYOBError();
	
	
}
