<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of MYOBTaxCodeReferenceFinder
 *
 * @author User
 */
class MYOBTaxCodeReferenceFinder implements MYOBReferenceFinder
{
	/**
	 * Check the given active record in MYOB	 * 
	 */
	public function hasRecord(\MYOBApiConnector $myobConnector, \CActiveRecord $activeRecord)
	{

		
		if ($activeRecord->uuid) {

			$myobConnector->setURLEndPoint('GeneralLedger/TaxCode/' . $activeRecord->uuid);
			$response = $myobConnector->apiGet(); /* if success apiGet returns array of MYOBResponse objects */
			if ($myobConnector->getCurlResponseCode() == 200 && $response[0]) {
				return $response[0];
			}
		}
		/* if the local record doesn't have myob references search by other references */
		$myobConnector->setURLEndPoint('GeneralLedger/TaxCode/');
		$myobConnector->setODataFilter('Code eq \'' . $activeRecord->code . '\'');
		$response = $myobConnector->apiGet();
		
		if ($myobConnector->getCurlResponseCode() == 200 && $response[0]) {
			return $response[0];
		} else {
			return false;
		}
	}

	/**
	 * Check the given MYOB record in local database
	 * @return mixed the first row (in terms of an array which has only cussno as id) of the query result, false if no result.
	 */
	public function hasRecordInLocal(\MYOBResponse $myobResponse)
	{
		return Yii::app()->db->createCommand()
				->select('id')
				->from('myob_tax_codes')
				->where(
						'(uuid=:UID AND myob_guid_uuid=:GUID) OR code=:CODE', 
						array(
							':UID' => $myobResponse->UID,
							':GUID' => Yii::app()->session['myob_guid'],
							':CODE' => $myobResponse->Code							
							)
						)
				->queryRow();		
	}

}
