<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of QuoteEmailTemplateTextFromatter
 *
 * @author Eranga
 */
class QuoteEmailTemplateTextFromatter extends TemplateTextFormatter {

    private $quotation;
    
    public function __construct(Quatation $model) {
        $this->quotation = $model;
    }
    
    public function format(string $text_contents) {
        
        $placeholders = ["QUOTE_NUMBER", "ONLINE_ACCEPTANCE_LINK", "SALESPERSON"];
        $replacers = [];
        $replacers[] = $this->quotation->quoteno;
        //generate online acceptance link and format
        $this->quotation->generateOnlineAcceptLink(); 
        $replacers[] = "<a "
                . "href='{$this->quotation->onlineAcceptenceLog->accept_url}'"
                . "data-mce-href='{$this->quotation->onlineAcceptenceLog->accept_url}'>"//'data-mce-href' required for TINY text editor, otherwise 'href' attribute will be replaced by URL without domain name
                . "{$this->quotation->onlineAcceptenceLog->accept_url}</a>";      
        $replacers[] = ucwords($this->quotation->salesPersonRel->name);

        return str_replace($placeholders, $replacers, $text_contents);
    }

}
