<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of RemoteImageSaver
 *
 * @author Eranga
 */
class RemoteImageSaver {

    public $searchables = array();

    public function addSearchable($searchabl) {

        if ($searchabl instanceof RemoteImageSearchable) {
            $this->searchables[] = $searchabl;
        }

        return $this;
    }

    public function saveRemoteToLocal() {

        foreach ($this->searchables as $key => $searchabl) {



            foreach ($searchabl->search() as $model) {

                $modelName = get_class($model);
                $categoryType = '';

                switch ($modelName) {
                    case 'ProductLine': $categoryType = SalesLog::CATEGORY_PRODUCT;
                        break;
                    case 'QuatationDetails': $categoryType = SalesLog::CATEGORY_QUOTATION_DETAIL;
                        break;
                    case 'Workorderdetails': $categoryType = SalesLog::CATEGORY_WORKORDER_DETAIL;
                        break;
                }

                if (!$model->{$searchabl->dbImageFieldName}) {

                    throw new Exception("No database image field name specified for $modelName", 401);
                }



                if (strpos($model->{$searchabl->dbImageFieldName}, 'http:') !== false || strpos($model->{$searchabl->dbImageFieldName}, 'https:') !== false) {

                    try {
                        $remoteURL = $model->{$searchabl->dbImageFieldName};
                        $fileName = basename($remoteURL);

                        if ($content = $this->curl_get_file_contents($remoteURL)) {

                            //if already exist remove the file before save                    
                            @unlink($searchabl->imageLocater . $fileName);

                            if (@file_put_contents($searchabl->imageLocater . $fileName, $content)) {

                                $model->{$searchabl->dbImageFieldName} = $fileName;



                                if ($model->save(false)) {
                                    $this->log(array(
                                        'tbl_id' => $model->{$searchabl->primaryKey},
                                        'category' => $categoryType,
                                        'comments' => "Remote image [$remoteURL] has been saved to local as [$fileName]",
                                    ));
                                } else {
                                    $this->log(array(
                                        'tbl_id' => $model->{$searchabl->primaryKey},
                                        'category' => $categoryType,
                                        'comments' => "Remote image [$remoteURL] cannot be saved to local!",
                                    ));
                                }
                            } else {
                                $this->log(array(
                                    'tbl_id' => $model->{$searchabl->primaryKey},
                                    'category' => $categoryType,
                                    'comments' => "Cannot put file content from the URL [$remoteURL]!",
                                ));
                            }
                        } else {
                            $this->log(array(
                                'tbl_id' => $model->{$searchabl->primaryKey},
                                'category' => $categoryType,
                                'comments' => "Cannot get the file content from the URL [$remoteURL]!",
                            ));
                        }
                    } catch (Exception $ex) {
                        $this->log(array(
                            'tbl_id' => $model->{$searchabl->primaryKey},
                            'category' => $categoryType,
                            'comments' => $ex->getMessage() . "\n" . $ex->getLine() . "\n" . $ex->getFile(),
                        ));
                    }
                }
            }
        }
    }

    function curl_get_file_contents($URL) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $URL);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTP_CONTENT_DECODING, false);
        $contents = curl_exec($ch);
        $info = curl_getinfo($ch);
        curl_close($ch);

        if ($contents) {
            return $contents;
        } else {
            return false;
        }
    }

    function log($log = array()) {
        $command = Yii::app()->db->createCommand();

        $command->insert('sales_log', array(
            'tbl_id' => $log['tbl_id'],
            'category' => $log['category'],
            'comments' => $log['comments'],
        ));
    }

}
