<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of SalesOrderEmailTemplateTextFromatter
 *
 * @author Eranga
 */
class SalesOrderEmailTemplateTextFromatter extends TemplateTextFormatter {
    private $salesOrder;
    
    public function __construct(Workorder $model) {
        $this->salesOrder = $model;
    }
    
    public function format(string $text_contents) {
        
        $placeholders = ["SO_NUMBER", "ONLINE_ACCEPTANCE_LINK", "SALESPERSON"];
        $replacers = [];
        $replacers[] = $this->salesOrder->salesorderNumber;
        //generate online acceptance link and format
        $this->salesOrder->generateOnlineAcceptLink(); 
        $replacers[] = "<a "
                . "href='{$this->salesOrder->onlineAcceptenceLog->accept_url}'"
                . "data-mce-href='{$this->salesOrder->onlineAcceptenceLog->accept_url}'>"//'data-mce-href' required for TINY text editor, otherwise 'href' attribute will be replaced by URL without domain name
                . "{$this->salesOrder->onlineAcceptenceLog->accept_url}</a>";      
        $replacers[] = ucwords($this->salesOrder->salesperson->name);

        return str_replace($placeholders, $replacers, $text_contents);
    }
}
