<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of QuoteEmailTemplateTextFromatter
 *
 * @author Eranga
 */
class WebstoreOrderEmailTemplateTextFromatter extends TemplateTextFormatter {

    private $webstoreOrder;
    
    public function __construct(WebstoreOrder $model) {
        $this->webstoreOrder = $model;
    }
    
    public function format(string $text_contents) {
        
        $placeholders = ["WEBSTORE_NUMBER", "ONLINE_ACCEPTANCE_LINK"];
        $replacers = [];
        $replacers[] = $this->webstoreOrder->orderNumber;
        //generate online acceptance link and format
        $this->webstoreOrder->generateOnlineAcceptLink(); 
        $replacers[] = "<a "
                . "href='{$this->webstoreOrder->onlineAcceptenceLog->accept_url}'"
                . "data-mce-href='{$this->webstoreOrder->onlineAcceptenceLog->accept_url}'>"//'data-mce-href' required for TINY text editor, otherwise 'href' attribute will be replaced by URL without domain name
                . "{$this->webstoreOrder->onlineAcceptenceLog->accept_url}</a>";      
       

        return str_replace($placeholders, $replacers, $text_contents);
    }

}
