<?php

// *********************************************************************
//
//      Class MYOB API OAUTH
//         
//           Sample Written by Keran McKenzie
//           Date: Feb 2013
//
//      Provided as sample oauth class for PHP & cURL OAUTH
//
//
// ********************************************************************

class myob_api_oauth {

    // public function to get an access token
    public function getAccessToken($api_key, $api_secret, $redirect_url, $access_code, $scope) {


        // build up the params
        $params = array(
            'client_id' => $api_key,
            'client_secret' => $api_secret,
            'scope' => $scope,
            'code' => $access_code,
            'redirect_uri' => $redirect_url,
            'grant_type' => 'authorization_code', // authorization_code -> gives you an access token
        ); // end params array */

        $params = http_build_query($params); // will urlencode data
        return( $this->getToken($params) );
    }

    // public function to refresh an access token
    public function refreshAccessToken($api_key, $api_secret, $refresh_token) {
        // use the getAccessToken function
        $params = array(
            'client_id' => $api_key,
            'client_secret' => $api_secret,
            'refresh_token' => $refresh_token,
            'grant_type' => 'refresh_token', // refresh_token -> refreshes your access token
        ); // end params array */

        $params = http_build_query($params);

        return( $this->getToken($params) );
    }

    // private function for token calls
    private function getToken($params) {

        //echo $params;
        // setup the session & setup curl options
        $headers = array(            
            'Content-Type: application/x-www-form-urlencoded'
        );
        $response = $this->getURL('https://secure.myob.com/oauth2/v1/authorize', $params, $headers);

        $response_json = json_decode($response);

        // ***********************
        //
		//  TODO: ERROR CHECKING
        //
		// **********************
        // if no errors update the tokens
        return($response_json);
    }

    // private function for CURL
    private function getURL($url, $params, $headers = null) {

        $session = curl_init($url);
        // do we have headers? set them
        if (isset($headers)) {
            curl_setopt($session, CURLOPT_HTTPHEADER, $headers);
        }
        // Tell curl to use HTTP POST
        curl_setopt($session, CURLOPT_POST, true);
        // Tell curl that this is the body of the POST
        curl_setopt($session, CURLOPT_POSTFIELDS, $params);
        // setup the authentication
        //curl_setopt($session, CURLOPT_USERPWD, $_SESSION['username'] . ":" . $_SESSION['password']);
        // Tell curl not to return headers, but do return the response
        curl_setopt($session, CURLOPT_HEADER, false);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, true);



        $response = curl_exec($session);
        curl_close($session);
        //var_dump($response);
        return($response);
    }

    public static function getDetails($url) {
        //echo 'token: '.$_SESSION['access_token'];
        // build the cftoken
        $cftoken = base64_encode(':');
        //$api_key = MyobSetting::getSettings()->api_key;

        // setup the session & setup curl options
        $headers = array(
            'Authorization: Bearer ' . Yii::app()->session['access_token'],
            //'x-myobapi-cftoken: ',
            'x-myobapi-key: axekz2fjukktzk3panc4b8bn',
            'x-myobapi-version: v2',
            //'Content-Type: application/json'
        );



        $session = curl_init($url);
        curl_setopt($session, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($session, CURLOPT_HEADER, false);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($session, CURLOPT_VERBOSE, true);
        $verbose = fopen(dirname(__FILE__) . '/curlheader.txt', 'w+');
        curl_setopt($session, CURLOPT_STDERR, $verbose);


        // get the response & close the session
        $response = curl_exec($session);
        curl_close($session);
        // return what we got
        return($response);
    }

    public static function postDetails($url, $put_json) {
        $username = '';
        $password = '';
        $cftoken = base64_encode($username . ':' . $password);
        $api_key = MyobSetting::getSettings()->api_key;

        $headers = array(
            'Authorization: Bearer ' . Yii::app()->session['access_token'],
            //'x-myobapi-cftoken: ' . $cftoken,
            'x-myobapi-key: axekz2fjukktzk3panc4b8bn',
            'x-myobapi-version: v2',
            'Content-Type: application/json'
        );





        $newsession = curl_init($url);

        curl_setopt($newsession, CURLOPT_HTTPHEADER, $headers); //load all header data
        curl_setopt($newsession, CURLOPT_POST, true); //comment out this PUT line to change to a POST statement
        curl_setopt($newsession, CURLOPT_USERPWD, $username . ':' . $password);
        curl_setopt($newsession, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($newsession, CURLOPT_POSTFIELDS, $put_json);
        curl_setopt($newsession, CURLOPT_SSL_VERIFYHOST, true);
        curl_setopt($newsession, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($newsession, CURLOPT_VERBOSE, true);
        $verbose = fopen(dirname(__FILE__) . '/curlheader.txt', 'w+');
        curl_setopt($newsession, CURLOPT_STDERR, $verbose);

        $response = curl_exec($newsession);

        curl_close($newsession);

        return $response;
    }

    public static function putDetails($url, $put_json) {
        $username = '';
        $password = '';
        $cftoken = base64_encode($username . ':' . $password);
        $api_key = MyobSetting::getSettings()->api_key;
        
        $headers = array(
            'Authorization: Bearer ' . Yii::app()->session['access_token'],
            //'x-myobapi-cftoken: ' . $cftoken,
            'x-myobapi-key: axekz2fjukktzk3panc4b8bn',
            'x-myobapi-version: v2',
            'Content-Type: application/json'
        );





        $newsession = curl_init($url);

        curl_setopt($newsession, CURLOPT_HTTPHEADER, $headers); //load all header data
        curl_setopt($newsession, CURLOPT_POST, true); //comment out this PUT line to change to a POST statement
        curl_setopt($newsession, CURLOPT_USERPWD, $username . ':' . $password);
        curl_setopt($newsession, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($newsession, CURLOPT_POSTFIELDS, $put_json);
        curl_setopt($newsession, CURLOPT_SSL_VERIFYHOST, true);
        curl_setopt($newsession, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($newsession, CURLOPT_VERBOSE, true);
        $verbose = fopen(dirname(__FILE__) . '/curlheader.txt', 'w+');
        curl_setopt($newsession, CURLOPT_STDERR, $verbose);

        $response = curl_exec($newsession);

        curl_close($newsession);

        return $response;
    }

    public static function hasAccess() {
        if (!isset(Yii::app()->session['access_token_expires']) || !isset(Yii::app()->session['myob_guid'])) {
            return false;
        }

        $expiry_time = time(); // + 600; // note I ad 600 seconds so we get a refresh token before our token expires
        if ($expiry_time > Yii::app()->session['access_token_expires']) {
            return false;
        } else {
            return true;
        }
    }

    public static function getIDFromJsonResponse($response, $key, $val) {
        $response = json_decode($response, true);

        foreach ($response["Items"] as $arr) {
            $UUID = 0;
            foreach ($arr as $k => $v) {

                if ($k == 'UID') {
                    $UUID = $v;
                }
                if ($k == $key && $v == $val) {
                    return $UUID;
                }
            }
        }

        return 0;
    }

    public static function getFieldsFromJsonResponse($response, $key, $val) {
        $response = json_decode($response, true);

        foreach ($response["Items"] as $arr) {

            $fieldvals = array();

            foreach ($arr as $k => $v) {


                if ($k == $key && $v == $val) {
                    $fieldvals['UID'] = $arr["UID"];
                    $fieldvals['RowVersion'] = $arr["RowVersion"];
                    return $fieldvals;
                }
            }
        }

        return null;
    }

    public static function extractErrorToHtml($response) {
        $errorready = false;
        $html = '';
        if (!is_array($response)) {
            $response = json_decode($response, true);
        }
        
        //myob validation errors
        if (isset($response["Errors"])) {
            $errorready = true;
        }


        if ($errorready) {

            $html .= '<p class="well"><span class="label label-important">MYOB Error</span> Admin Guid<br/>';
            foreach ($response["Errors"] as $arr) {
                foreach ($arr as $key => $value) {
                    $html .= $key . " : " . $value . '<br>';
                }
            }

            if (isset($response["Information"])) {
                $html .= "Information :" . $response["Information"];
            }
            $html .= '</p>';
        }
        //end validation errors
        
        //myob access errors
        
        if (isset($response["Message"])) {
            $errorready = true;
        }
        
        if ($errorready) {
            $html .= '<p class="well"><span class="label label-important">MYOB Error</span> Admin Guid<br/>';
            $html .= "Message : " . $response["Message"];
        }

        return $html;
    }
    
    
    public static function directPut($json,$query) {
        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . $query;
        return self::putDetails($url, $json);
    }
    public static function directGet($query) {
        $url = 'https://api.myob.com/accountright/' . Yii::app()->session['myob_guid'] . $query;
        return self::getDetails($url);
    }

}

// end class