<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of OnlineQuoteBuilder
 *
 * @author User
 */
class OnlineQuoteBuilder implements OrderBuilder
{
	protected $orderheader;
	protected $orderDetails = [];

	public function setHeader(OderHeader $orderHeader): \OrderBuilder
	{
		$this->orderheader = $orderHeader;
		return $this;
	}
	

	public function setDetail(\OderDetail $orderDetail): \OrderBuilder
	{
		$this->orderDetails[] = $orderDetail;
		return $this;
	}

	
	
	public function build(): \Order
	{
		if ($this->orderheader->id || $this->orderheader->save()) {
			foreach ($this->orderDetails as $detail) {
				$detail->quoteid = $this->orderheader->id;
				$detail->save();
			}
			
			return new OnlineQuoteOrder($this->orderheader->id);
		}
		
		return null;
	}

}
