<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of OnlineQuoteDetailBuilder
 *
 * @author User
 */
class OnlineQuoteDetailBuilder implements OrderDetailBuilder {

    protected $quotation;
    protected $quoteDetail;
    protected $decorations = array();
    protected $otherCosts = array();
    protected $imageIncetances = array();

    public function setDecoration(array $attributes): OrderDetailBuilder {
        if ($this->quoteDetail) {
            $quotedecodetail = new QuoteProductDecoration();

            $quotedecodetail->decprtnam = $attributes['decprtnam'];

            $decoration = $quotedecodetail->decprtnam ? Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $quotedecodetail->decprtnam))) : null;
            if ($decoration) {
                $maindeco = Decoration::model()->find(array('condition' => 'decsno=:ID', 'params' => array(':ID' => $decoration->decmaintypsno)));
            }




            $quotedecodetail->productsku = $this->quoteDetail->productsku;
            $quotedecodetail->decorationdescription = $decoration->decnam;

            $quotedecodetail->decorationunitval = $attributes['decorationunitval'];
            $quotedecodetail->customerdicspcn = 0;
            $quotedecodetail->maindecorationid = !empty($maindeco) ? $maindeco->decprtnam : '';
            $quotedecodetail->decorationfreightval = 0;

            $globlavar = GlobalVars::model()->find(array('condition' => " trim(globalVar) = 'GST'"));
            $quotedecodetail->decorationvat = !empty($globlavar) ? $globlavar->value : 0;
            $quotedecodetail->logosetupcharge = $attributes['logosetupcharge'];
            $quotedecodetail->supref = (!empty($decoration) ? (!empty($decoration->supplier) ? $decoration->supplier->supsup_fref : '') : '');
            $quotedecodetail->supmarg = $attributes['supmarg'];

            $quotedecodetail->logoSetupMarkupRate = $attributes['logoSetupMarkupRate'];
            $quotedecodetail->logoSetupUnitCost = $attributes['logoSetupUnitCost'];
            $quotedecodetail->logoSetupUnitCostWithMarkup = $attributes['logoSetupUnitCostWithMarkup'];



            $this->decorations[] = $quotedecodetail;
        }

        return $this;
    }

    public function setDetail(array $attributes): OrderDetailBuilder {

        //select product details according to the product source - LOCAL_DB or GWS_API
        $product_source = ProductLine::PRODUCT_SOURCE_LOCAL_DB;
        if ($attributes['adnew_prd_source'] == ProductLine::PRODUCT_SOURCE_LOCAL_DB) {
            $productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:productKey', 'params' => array(':productKey' => $attributes['adnew_prd_code'])));
            if(!$productline) {
                //cannot complete the request
                throw new Exception("Product Not Found", 404);
            }

            $productName = $productline->pdlprdline;
            $productLongDesc = $productline->pdldes;
            $productSupplierCode = $productline->supplier->supsup_fref;
            $productImage = $productline->getImgField();
            $productSupplierName = $productline->supplier->supnam;
        } else if ($attributes['adnew_prd_source'] == ProductLine::PRODUCT_SOURCE_GWS_API) {
            $product_source = ProductLine::PRODUCT_SOURCE_GWS_API;
            $postFields = GwsProductApi::getDefaultPostFields();
            $postFields['data'] = array(
                'supplier' => '',
                'product_code' => $attributes['adnew_prd_code'],
                'product_Name' => '',
                'category' => ''
            );

            $productData = GwsProductApi::productData($postFields);
            if (isset($productData[0]) && $product = $productData[0]) {
                $productName = $product['pro_name'];
                $productLongDesc = $product['long_desc'];
                $productSupplierCode = $product['supplier'];
                $productImage = GwsProductApi::getImageFile($product);
                $productSupplierName = $product['supplier_name'];
            } else {
                //cannot complete the request
                throw new Exception("Product Not Found", 404);
            }
        }


        $quoteId = $attributes['quoteid'];
        $this->quotation = $this->quotation ?: Quatation::model()->findByPk($quoteId);

        $sql = "select COUNT(1) as lineCount from quatationdetails where quoteid = '$quoteId'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        $this->quoteDetail = new QuatationDetails();
        $this->quoteDetail->lineOrder = (intval($result['lineCount']) + 1) ?? 1;
        $this->quoteDetail->quoteid = $quoteId;
        $this->quoteDetail->productsku = $attributes['adnew_prd_code'];
        $this->quoteDetail->qty = $attributes['adnew_edit_itm_qty'];

        //if product name or product description edited then save it to variables
        $editproductname = $attributes['prd_edited_description'] ?: "";
        $editproductdescription = $attributes['prd_edited_long_description'] ?: "";


        $globlavar = GlobalVars::model()->find(array('condition' => " trim(globalVar) = 'GST'"));

        $this->quoteDetail->productexunitprice = $attributes['adnew_cost_price'];
        //set  quote products name & product description, check for edited else take it from product table
        $this->quoteDetail->productname = $editproductname ?: $productName;
        $this->quoteDetail->productdescription = $editproductdescription ?: $productLongDesc;
        //
        //$quotedetail->supmarg = $productline->pdlsupmargin;
        $this->quoteDetail->sup_fref = $productSupplierCode;
        //$quotedetail->supmarg = $productline->pdlsupmargin;
        $this->quoteDetail->customerdicspcn = $attributes['adnew_discount_percntg'];
        $this->quoteDetail->productimg = $productImage;
        $this->quoteDetail->iscustomprodct = 0;
        $this->quoteDetail->prodctfrieght = $attributes['adnew_usd_freight'];
        $this->quoteDetail->productvat = $globlavar ? $globlavar->value : 0;
        $this->quoteDetail->supname = $productSupplierName;
        $this->quoteDetail->supmarg = $attributes['adnew_prd_markup'];
        $this->quoteDetail->supmargPercentage = $attributes['adnew_prd_markup_percentage'];

        $this->quoteDetail->system_freight = $attributes['adnew_freight_rate'];
        $this->quoteDetail->systemFreightPercentage = $attributes['adnew_freight_percentage'];
        $this->quoteDetail->other_cost = $attributes['adnew_othercost_total'];
        $this->quoteDetail->other_cost_markup_rate = $attributes['adnew_othercost_markup_rate'];
        $this->quoteDetail->otherCostMarkupPercentage = $attributes['adnew_othercost_markup_percentage'];

        //recalculate price totals
        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        $gst = floatval(GlobalVars::get('GST'));
        $this->quoteDetail->systemTaxRateId = $attributes['adnew_tax_rate_id']; //system tax code
        if ($this->quoteDetail->systemTaxRateId) {
            $gst = SystemTaxCode::model()->findByPk($this->quoteDetail->systemTaxRateId)->rate;
        }

        $this->quoteDetail->sellunitprice_ex_vat = round($attributes['adnew_edit_total'], $roundingPrecision);
        $this->quoteDetail->selltot_ex_vat = round(($attributes['adnew_edit_total'] * $this->quoteDetail->qty), $roundingPrecision);

        $this->quoteDetail->sellunitprice_in_vat = $gst ? round(($this->quoteDetail->sellunitprice_ex_vat * $gst), $roundingPrecision) : $this->quoteDetail->sellunitprice_ex_vat;
        $this->quoteDetail->selltot_in_vat = round(($this->quoteDetail->sellunitprice_in_vat * $this->quoteDetail->qty), $roundingPrecision);


        $this->quoteDetail->productFrieghtUnitCost = $attributes['adnew_usd_freight_unit_cost'];
        $this->quoteDetail->productFrieghtMarkUpRate = $attributes['adnew_usd_freight_markup_rate'];
        $this->quoteDetail->productFrieghtMarkUpPercentage = $attributes['adnew_usd_freight_markup_percentage'];
        $this->quoteDetail->productFrieghtUnitCostWithMarkup = $attributes['adnew_usd_freight_unit_markedup_price'];
        $this->quoteDetail->lockSellPrice = intval($attributes['lockSellPrice']) ?? 0;
        
        $this->quoteDetail->product_source = $product_source;





        return $this;
    }

    public function setSizeQtyColorMatrix(array $attributes): OrderDetailBuilder {
        //not yet implemented
        return $this;
    }

    public function setImage(CUploadedFile &$fileInstance, $fileName = ''): OrderDetailBuilder {
        $this->imageIncetances[] = array(
            'fileInstance' => &$fileInstance,
            'fileName' => $fileName
        );

        return $this;
    }

    public function setOtherCost(array $attributes): OrderDetailBuilder {
        if (isset($attributes['other_cost_id']) && isset($attributes['cost'])) {
            $quoteOtherCost = new QuoteOtherCost();
            $quoteOtherCost->other_cost_id = $attributes['other_cost_id'];
            $quoteOtherCost->cost = $attributes['cost'];
            $quoteOtherCost->created_by = Yii::app()->user->id;
            $quoteOtherCost->created_date = date('Y-m-d');


            $this->otherCosts[] = $quoteOtherCost;
        }


        return $this;
    }

    //put your code here
    public function build(): OderDetail {
        if ($this->quoteDetail && $this->quoteDetail->save()) {
            foreach ($this->decorations as $quoteDecoDetail) {
                $quoteDecoDetail->quoteid = $this->quotation->id;
                $quoteDecoDetail->ws_id = $this->quotation->ws_id;
                $quoteDecoDetail->quataiondetailsid = $this->quoteDetail->id;
                $quoteDecoDetail->productsku = $this->quoteDetail->productsku;
                $quoteDecoDetail->decorationqty = $this->quoteDetail->qty;
                $quoteDecoDetail->save();
            }

            foreach ($this->otherCosts as $otherCost) {

                $otherCost->quote_id = $this->quotation->id;
                $otherCost->quote_detail_id = $this->quoteDetail->id;

                $otherCost->save();
            }

            foreach ($this->imageIncetances as $key => $arr) {
                $fileInstance = $arr['fileInstance'];
                $fileName = $arr['fileName'];
                if ($fileInstance) {

                    $renamedImage = ($fileName ?: time()) . '.' . $fileInstance->getExtensionName();
                    if ($fileInstance->saveAs('images/product_img/' . $renamedImage)) {
                        $this->quoteDetail->productimg = $renamedImage;
                        $this->quoteDetail->save();
                    }
                }
            }

            return new QuoteOrderDetail($this->quoteDetail);
        }

        return null;
    }

}
