<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of PurchaseOrderDeleteFacade
 *
 * @author User
 */
class PurchaseOrderDeleteFacade
{

	/**
	 * This will handle all the subsystems that need to delete the PO correctly
	 * @param CActiveRecord $purchaseOrder
	 * @param array $response reference array to store failure and success message and type
	 * @return bool
	 */
	public function deleteOrder(PurchaseOrders $purchaseOrder, array &$response): bool
	{
		if ($grn = GoodsReceived::model()->find("po_id = '$purchaseOrder->id'")) {
			$response['type'] = 'error';
			$response['message'] = "Connot delete purchase order  ({$purchaseOrder->poNum}) Please delete goods received note ({$grn->grnnum}) first. Please try again.";
			return false;
		}


		$gin = null;
		if ($purchaseOrder->poType == 'Purchase Product-Decoration') {

			if ($gin = GoodsIssueNote::model()->find("po_id = '$purchaseOrder->id'")) {
				$response['type'] = 'error';
				$response['message'] = "Connot delete purchase order  ({$purchaseOrder->poNum}) Please delete goods issue note ({$gin->ginnum}) first. Please try again.";
				return false;
			}
		}

		$podtls = PurchaseOrderDetails::model()->findAll("po_id = '$purchaseOrder->id'");
		
		foreach ($podtls as $dtl) {

			if (trim($purchaseOrder->poType) == 'Purchase Product') {


				$jobactivityflow = JobActivityFlow::model()->find("flowjob_id = '{$dtl->flowjob_id}' and type = 'Product' and activity = 'PO Created' ");
				if ($jobactivityflow && $jobactivityflow->delete()) {
					$jobprodcut = JobProducts::model()->find("job_id = '{$purchaseOrder->job_id}' and workorderDtl_id = '{$dtl->workorderDtl_id}' and po_id = '{$purchaseOrder->id}' ");
					if ($jobprodcut) {
						$jobprodcut->po_id = null;
						$jobprodcut->save();
					}
				}
			} else if (trim($purchaseOrder->poType) == 'Purchase Product-Decoration') {

				$jobactivityflow = JobActivityFlow::model()->find("flowjob_id = '{$dtl->flowjob_id}' and type = 'Product-Decoration' and activity = 'PO Created' ");
				if ($jobactivityflow && $jobactivityflow->delete()) {
					$jobdecorationprd = JobProductDecorations::model()->find("job_id = '{$purchaseOrder->job_id}' and workorderDtl_id = '{$dtl->workorderDtl_id}' and po_id = '{$purchaseOrder->id}'");
					if ($jobdecorationprd) {
						$jobdecorationprd->po_id = null;
						$jobdecorationprd->save();
					}
				}
			} else if (trim($purchaseOrder->poType) == 'Purchase Artwork') {

				$jobactivityflow = JobActivityFlow::model()->find("flowjob_id = '{$dtl->flowjob_id}' and type = 'Decoration' and activity = 'Artwork PO Created' ");
				if ($jobactivityflow && $jobactivityflow->delete()) {
					$jobdeco = JobDecorations::model()->find("job_id = '{$purchaseOrder->job_id}' and workorderDtl_id = '{$dtl->workorderDtl_id}' and po_id = '{$purchaseOrder->id}'");
					if ($jobdeco) {
						$jobdeco->po_id = null;
						$jobdeco->save();
					}
				}
			}
		}

		$podetailsdeleted = false;
		if (PurchaseOrderDetails::model()->deleteAll("po_id = '$purchaseOrder->id'")) {
			$podetailsdeleted = true;
		}

		$ponum = $purchaseOrder->poNum;
		if ($podetailsdeleted == true) {
			$ponum = $purchaseOrder->poNum;
			if ($purchaseOrder->delete()) {
				$response['type'] = 'success';
				$response['message'] = "Purchase order {$ponum} successfully deleted.";
				SalesLog::createSalesLog($purchaseOrder->workorder->quotationId, $purchaseOrder->workorder->id, $purchaseOrder->workorder->quotationNumber, 'Job', "Purchase order ({$purchaseOrder->poNum}) is deleted", 1, 1, 1);
				SalesLog::createSalesLog($purchaseOrder->workorder->quotationId, $purchaseOrder->workorder->id, $purchaseOrder->workorder->quotationNumber, 'PurchaseOrder', "Purchase order ({$purchaseOrder->poNum}) is deleted", 1, 1, 1);

				return true;
			} else {
				$response['type'] = 'error';
				$response['message'] = "Final step failed on deleting the purchase order {$ponum}.";
				return false;
			}
			
		} else {
			$response['type'] = 'error';
			$response['message'] = "Connot delete purchase order ({$ponum}). Please try again.";

			return false;
		}
	}

}
