<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of WorkOrderCreator
 *
 * @author User
 */
class WorkOrderConvertor extends OrderConvertor
{
	protected $quotation;
	public function __construct(Quatation $quotation)
	{
		$this->quotation = $quotation;
	}
	
	/**
	 * Trying to create work order entity based on the quotation
	 * @return Order
	 */
	public function convert(): \Order
	{
		$transaction = Yii::app()->db->beginTransaction();
		$allsaved = true;
		
		
		$workorder = new Workorder();
		$workorder->quotationId = $this->quotation->id;
		$workorder->salesorderNumber = "SO-" . $this->quotation->quoteno . "-" . (1 + Workorder::getSOCountOfQuote($this->quotation->id));
		$workorder->quotationNumber = $this->quotation->quoteno;
		$workorder->cus_fref = $this->quotation->cus_fref;
		$workorder->mastercusno = $this->quotation->customer->cusmcussno;

		$workorder->status_id = Status::model()->find(array('condition' => 'name=:status', 'params' => array(':status' => 'New')))->id;
		$workorder->createddate = date("Y-m-d g:i");
		$workorder->createdby = Yii::app()->user->id;
		$workorder->ws_user = $this->quotation->ws_user;
		$workorder->ws_user_id = $this->quotation->ws_user_id;
		$workorder->dueDate = date('Y-m-d', strtotime($this->quotation->dueDate));

		$workorder->shipContactName = $this->quotation->shipContactName ?: $this->quotation->customer->cuscontact;
		$workorder->shipSendVia = $this->quotation->shipSendVia;
		$workorder->shipAddress1 = $this->quotation->shipAddress1 ?: $this->quotation->customer->shipAddress1;
		$workorder->shipAddress2 = $this->quotation->shipAddress2 ?: $this->quotation->customer->shipAddress2;
		$workorder->shipAddress3 = $this->quotation->shipAddress3 ?: $this->quotation->customer->shipAddress3;
		$workorder->shipSub = $this->quotation->shipSub ?: $this->quotation->customer->custown;
		$workorder->shipState = $this->quotation->shipState ?: $this->quotation->customer->cusstate;
		$workorder->shipPostalCode = $this->quotation->shipPostalCode ?: $this->quotation->customer->cuspostcode;

		if ($allsaved = $workorder->save()) {



			$quotationDetails = QuatationDetails::model()->findAll(array('condition' => "quoteid = '{$this->quotation->id}'", 'order' => 'lineOrder ASC'));


			foreach ($quotationDetails as $detail) {

				$workorderDetails = Workorderdetails::createDetailByQuoteItem($workorder->id, $detail);
				
			}

			//Trying to copy quote related attachments into workorder
			try {
				FileInventory::copyAttachments($this->quotation->id, 'QUOTATION', $workorder->id, 'WORKORDER');
			} catch (Exception $ex) {
				
			}
		} 
		
		if( $allsaved ) {
			$transaction->commit();
			return  new SWorkOrder($workorder->id);
			
		} else {
			$transaction->rollback();
			return null;
		}
	}

}
