<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of WorkOrderHeaderBuilder
 *
 * @author User
 */
class WorkOrderHeaderBuilder implements OrderHeaderBuilder
{
	
	protected $referenceNumber;
	protected $dueDate;
	protected $contact;
	protected $contactName;
	protected $contactPhone;
	protected $officeAddress;
	protected $shippingAddress;
	protected $salesperson;
	protected $status;
	protected $extraFields = array();


	public function build(): \OrderHeader
	{
		$orderHeader = new WorkOrderHeader($orderHeader);
		
	}

	public function referenceNumber($referenceNumber): \OrderHeaderBuilder
	{
		$this->referenceNumber = $referenceNumber;
		return $this;
	}

	public function setContact(Contact $contact): \OrderHeaderBuilder
	{
		$this->contact = $contact;
		return $this;
	}

	public function setDueDate(string $date): \OrderHeaderBuilder
	{
		$this->dueDate = date('Y-m-d H:i:s', strtotime($date));
	}

	public function setExtraFields(array $attributes): \OrderHeaderBuilder
	{
		throw new Exception("Method not implementd Exception");
	}

	public function setOfficeAddress(Address $address): \OrderHeaderBuilder
	{
		$this->officeAddress = $address;
		return $this;
	}

	public function setSalesperson(SSalesperson $salesperson): \OrderHeaderBuilder
	{
		$this->salesperson = $salesperson;
		return $this;
	}

	public function setShippingAddress(Address $address): \OrderHeaderBuilder
	{
		$this->shippingAddress = $address;
		return $this;
	}

	public function setStatus(int $status): \OrderHeaderBuilder
	{
		$this->status = $status;
		return $this;
	}

	public function setContactName(string $contactName): \OrderHeaderBuilder
	{
		$this->contactName = $contactName;
		return $this;
	}

	public function setContactPhone(string $contactPhone): \OrderHeaderBuilder
	{
		$this->contactPhone = $contactPhone;
		return $this;
	}

}
