<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * WorkorderDetailBuilder can be used to compose one detail
 *
 * @author User
 */
class WorkorderDetailBuilder implements OrderDetailBuilder
{

	protected $workorderDetail;
	protected $decorations = array();
	protected $otherCosts = array();
	protected $imageIncetances = array();

	public function build(): \OderDetail
	{
		if ($this->workorderDetail->save()) {
			foreach ($this->decorations as $decoDetail) {
				$decoDetail->work_order_id = $this->workorderDetail->workorderId;
				$decoDetail->workorder_detail_id = $this->workorderDetail->id;
				$decoDetail->save();
			}

			foreach ($this->otherCosts as $otherCost) {

				$otherCost->workorder_id = $this->workorderDetail->workorderId;
				$otherCost->workorder_detail_id = $this->workorderDetail->id;

				$otherCost->save();
			}

			foreach ($this->imageIncetances as $key => $arr) {
				$fileInstance = $arr['fileInstance'];
				$fileName = $arr['fileName'];
				if ($fileInstance) {

					$renamedImage = ($fileName ?: time()) . '.' . $fileInstance->getExtensionName();
					if ($fileInstance->saveAs('images/product_img/' . $renamedImage)) {
						$this->workorderDetail->image = $renamedImage;
						$this->workorderDetail->save();
					}
				}
			}

			return new WorkOrderDetail($this->workorderDetail);
		}

		return null;
	}

	/**
	 * Set the decoration details one by one at each time
	 * @param array $attributes
	 */
	public function setDecoration(array $attributes): \OrderDetailBuilder
	{

		$workorderDeco = new WorkorderDetailsDecoration();
		$workorderDeco->decprtnam = $attributes['decprtnam'];

		$decoration = $workorderDeco->decprtnam ? Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $workorderDeco->decprtnam))) : null;



		$workorderDeco->decoration_id = $decoration->decsno;

		$workorderDeco->decdesc = $attributes['decorationdescription'];
		$workorderDeco->quantity = $attributes['decorationqty'];
		$workorderDeco->cost_price = $attributes['decorationunitval'];
		$workorderDeco->sup_margin = $attributes['supmarg'];
		$workorderDeco->sup_markedup_price = $attributes['supmargMarkedUpPrice'];
		$workorderDeco->logo_setup = $attributes['logosetupcharge'];
		$workorderDeco->logo_setup_unit_price = $attributes['logoSetupUnitCost'];
		$workorderDeco->logo_setup_markup_rate = $attributes['logoSetupMarkupRate'];
		$workorderDeco->logo_setup_unit_markedup_price = $attributes['logoSetupUnitCostWithMarkup'];
		$workorderDeco->decorationfreightval = $attributes['decorationfreightval'];
		$workorderDeco->decorationvat = $attributes['decorationvat'];
		$workorderDeco->supref = $decoration->supref;
		$workorderDeco->created_at = date('Y-m-d');
		$workorderDeco->created_by = Yii::app()->user->id;
		$workorderDeco->customization_detail = $attributes['customization_detail'];


		return $this;
	}

	/**
	 * Set the main item detail
	 * @param array $attributes - attributes names should be as it is
	 * @return OrderDetailBuilder 
	 */
	public function setDetail(array $attributes): \OrderDetailBuilder
	{
		$workorderId = $attributes['workorderId'];

		$sql = "SELECT COUNT(1) AS lineCount FROM workorderdetails WHERE workorderId = {$workorderId}";
		$result = Yii::app()->db->createCommand($sql)->queryRow();

		$this->workorderDetail = new Workorderdetails;
		$this->workorderDetail->lineOrder = (intval($result['lineCount']) + 1) ?? 1;
		$this->workorderDetail->workorderId = $workorderId;
		$this->workorderDetail->linetypeId = 1;
		$this->workorderDetail->productsku = $attributes['productsku'];

		//$productLine = ProductLine::model()->find(array('condition' => 'pdlpdl=:productKey', 'params' => array(':productKey' => $detail->productsku)));

		$this->workorderDetail->prdsrtdesc = $attributes['prdsrtdesc'];
		$this->workorderDetail->prdlngdesc = $attributes['prdlngdesc'];



		$this->workorderDetail->prodQty = $attributes['prodQty'];
		//$workorderDetails->decoQty = !empty($detail->decoration) ? $detail->decoration->decorationqty : 0;
		$this->workorderDetail->prodCostPrice = floatval($attributes['prodCostPrice']);
		//$workorderDetails->decoCostPrice = !empty($detail->decoration) ? floatval($detail->decoration->decorationunitval) : 0;
		$this->workorderDetail->prodsupref = $attributes['prodsupref'];
		//$workorderDetails->decosupref = !empty($detail->decoration) ? $detail->decoration->supref : '';
		$this->workorderDetail->sellPriceExVat = $attributes['sellPriceExVat'];
		$this->workorderDetail->sellPriceIncVat = $attributes['sellPriceIncVat'];
		$this->workorderDetail->totExVat = $attributes['totExVat'];
		$this->workorderDetail->totIncVat = $attributes['totIncVat'];


		$this->workorderDetail->prod_supmarg = $attributes['prod_supmarg'];


		$this->workorderDetail->prod_usd_freight = $attributes['prod_usd_freight'];


		//new USD freight mark-up values 2018-10-12
		$this->workorderDetail->productFrieghtUnitCost = $attributes['productFrieghtUnitCost'];
		$this->workorderDetail->productFrieghtMarkUpRate = $attributes['productFrieghtMarkUpRate'];
		$this->workorderDetail->productFrieghtUnitCostWithMarkup = $attributes['productFrieghtUnitCostWithMarkup'];


		$this->workorderDetail->image = $attributes['image'];

		$this->workorderDetail->prod_discount_pcntg = $attributes['prod_discount_pcntg'];

		$this->workorderDetail->system_freight = $attributes['system_freight'];


		$this->workorderDetail->other_cost = $attributes['other_cost'];
		$this->workorderDetail->other_cost_markup_rate = $attributes['other_cost_markup_rate'];

		$this->workorderDetail->createdby = Yii::app()->user->id;
		$this->workorderDetail->createddate = date("Y-m-d g:i");
		$this->workorderDetail->customizationDetails = $attributes['customizationDetails']; // this field will be used as custom detail
		$this->workorderDetail->notes = $attributes['notes'];

		$this->workorderDetail->lockSellPrice = $attributes['lockSellPrice'];
		$this->workorderDetail->systemTaxRateId = $attributes['systemTaxRateId'];

		return $this;
	}

	/**
	 * Store images each at a time
	 */
	public function setImage(\CUploadedFile &$fileInstance, $fileName = ''): \OrderDetailBuilder
	{
		$this->imageIncetances[] = array(
			'fileInstance' => &$fileInstance,
			'fileName' => $fileName
		);

		return $this;
	}

	/**
	 * Set the other cost details one by one at each time
	 * @param array $attributes
	 * @return OrderDetailBuilder
	 */
	public function setOtherCost(array $attributes): \OrderDetailBuilder
	{
		if (isset($attributes['other_cost_id']) && isset($attributes['cost'])) {
			$workorderOtherCost = new WorkorderOtherCost();
			$workorderOtherCost->other_cost_id = $attributes['other_cost_id'];
			$workorderOtherCost->cost = $attributes['cost'];
			$workorderOtherCost->created_by = Yii::app()->user->id;
			$workorderOtherCost->created_date = date('Y-m-d');


			$this->otherCosts[] = $workorderOtherCost;
		}


		return $this;
	}

	public function setSizeQtyColorMatrix(array $attributes): \OrderDetailBuilder
	{
		return $this;
	}

}
