<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of DefalutHeaderPDFGenerator
 *
 * @author User
 */
class DefalutHeaderPDFGenerator extends PlainPDFGenerator
{

	 
	public function __construct()
	{
		$this->pdfLibraryConfig = array(// More info: http://mpdf1.com/manual/index.php?tid=184
			'mode' => '', //  This parameter specifies the mode of the new document.
			'format' => 'A4', // format A4, A5, ...
			'default_font_size' => 0, // Sets the default document font size in points (pt)
			'default_font' => '', // Sets the default font-family for the new document.
			'mgl' => 10, // margin_left. Sets the page margins for the new document.
			'mgr' => 10, // margin_right
			'mgt' => 27, // margin_top
			'mgb' => 10, // margin_bottom
			'mgh' => 5, // margin_header
			'mgf' => 15, // margin_footer
			'orientation' => 'P', // landscape or portrait orientation
		);
		$this->pageConfig = array(
			'orientation' => 'P', // L - landscape, P - portrait 
			'condition' => '',
			'resetpagenum' => '',
			'pagenumstyle' => '',
			'suppress' => '',
			'mgl' => 5,
			'mgr' => 5,
			'mgt' => 25,
			'mgb' => 25,
			'mgh' => 0,
			'mgf' => 2,
		);		
		
	}
	
	public function generate()
	{
		require_once 'vendor/autoload.php';
		$mpdf = new \Mpdf\Mpdf($this->pdfLibraryConfig);
		
		$mpdf->SetHTMLHeader('<img src="images/pdf_default_header.jpg" style="width:100%;"/>', 'O', true);
		
		
		$mpdf->SetTitle($this->pdfTitleName);

		if ($this->templateFileName) {
			$template = $mpdf->SetSourceFile($this->templateFileName);
			$tplId = $mpdf->ImportPage($template);
			$mpdf->SetPageTemplate($tplId);
		}

		$mpdf->AddPage(
				$this->pageConfig['orientation'], $this->pageConfig['condition'], $this->pageConfig['resetpagenum'], $this->pageConfig['pagenumstyle'], $this->pageConfig['suppress'], $this->pageConfig['mgl'], $this->pageConfig['mgr'], $this->pageConfig['mgt'], $this->pageConfig['mgb'], $this->pageConfig['mgh'], $this->pageConfig['mgf']
		);

		$mpdf->WriteHTML($this->htmlContent);

		if ($this->pdfFooter || $this->pageNumberFormat) {
			$mpdf->defaultfooterline = 0;			
			$mpdf->setFooter($this->pdfFooter . $this->pageNumberFormat);
		}

		

		$mpdf->Output(($this->outputFileName ?? time()), $this->outputFileType);
	}

}
