<?php

/**
 * Quotation related pdf generating functionalities
 */

class MpsArtwork extends MpsPdf
{

    public function setMode(int $mode = 1)
    {
        $this->mode = $mode;

        return $this;
    }

    public function setModel($model)
    {
        $this->model = $model;

        return $this;
    }

    public function generate($html)
    {

        if ($this->mode === MpsPdf::MODE_CONTENT_GENERATOR) {
            $pagecount = $this->pdf->SetSourceFile('images/template/blank_template.pdf');
            //$this->pdf->setFooter('{PAGENO} / {nb}');

            if($defaultPdfLogoImage = SystemOptions::getOptions()->defaultPdfLogoImage) {
                $this->pdf->SetHTMLHeader(CHtml::image("images/logos/{$defaultPdfLogoImage}", '', array()));
             }
        }

        $tplId = $this->pdf->ImportPage($pagecount);
        $this->pdf->SetPageTemplate($tplId);
        $this->pdf->shrink_tables_to_fit = 1;

        $this->pdf->defaultfooterline = false;


        $this->pdf->SetTitle('Artwork Job');

        if ($this->mode === MpsPdf::MODE_CONTENT_GENERATOR) {
            $this->pdf->AddPage(
                'P', // L - landscape, P - portrait
                '', '', '', '', 10, // margin_left
                10, // margin right
                35, // margin top
                25, // margin bottom
                0, // margin header
                0); // margin footer
        }

        if ($this->mode === MpsPdf::MODE_TEMPLATE_GENERATOR) {



            $this->pdf->AddPage('', // L - landscape, P - portrait
            '', '', '', '', 1, // margin_left
            3, // margin right
            55, // margin top
            25, // margin bottom
            0, // margin header
            2); // margin footer

        }
        

        $this->pdf->WriteHTML($html);
        return $this;
    }
}
