<?php

/**
 * Quotation related pdf generating functionalities
 */

class MpsDeliveryNotePdf extends MpsPdf
{

    public function setMode(int $mode = 1)
    {
        $this->mode = $mode;

        return $this;
    }

    public function setModel($model)
    {
        $this->model = $model;

        return $this;
    }

    public function generate($html)
    {
        

        if (false) {
            $this->pdf->OverWrite(
                'images/template/DELIVERY_NOTE.pdf',
                array(
                    'COMPANY',
                    'CONTACT_NAME',
                    'ADDRESS',
                    'SHIPPED_BY',
                    'TELEPHONE',
                    'DATE',
                    'INVOICE_NUMBER',
                    'PO_NUMBER'
    
                ),
                array(
                    ucwords($this->model->companyName),
                    ucwords($this->model->contactName),
                    $this->model->getFullAddress(),
                    $this->model->shippedBySupplier ? $this->model->shippedBySupplier->supnam : '',
                    implode(' / ', array_filter(array($this->model->telephone1, $this->model->telephone2))),
                    date(GlobalVars::get("DateFormat"), strtotime($this->model->createdDtm)),
                    $this->model->invoice ? $this->model->invoice->invoiceNum : '',
                    $this->model->job->customerpono
    
    
                ),
                'F',
                'images/template/DELIVERY_NOTE_OVERWRITE.pdf'
            );
        }


        //rewrite the template with new header data and save
        //$mPDF1->SetImportUse();
        //set rewriten pdf file as source file
        if ($this->mode === MpsPdf::MODE_TEMPLATE_GENERATOR) {
            $pagecount = $this->pdf->SetSourceFile('images/template/DELIVERY_NOTE_BLANK.pdf');
        }

        if ($this->mode === MpsPdf::MODE_CONTENT_GENERATOR) {
            $pagecount = $this->pdf->SetSourceFile('images/template/blank_template.pdf');
            //$this->pdf->setFooter('{PAGENO} / {nb}');

            if($defaultPdfLogoImage = SystemOptions::getOptions()->defaultPdfLogoImage) {
                $this->pdf->SetHTMLHeader(CHtml::image("images/logos/{$defaultPdfLogoImage}", '', array()));
             }
        }

        $tplId = $this->pdf->ImportPage($pagecount);
        $this->pdf->SetPageTemplate($tplId);
        $this->pdf->shrink_tables_to_fit = 1;

        $this->pdf->defaultfooterline = false;


        $this->pdf->SetTitle('Quotation');

        if ($this->mode === MpsPdf::MODE_CONTENT_GENERATOR) {
            $this->pdf->AddPage(
                'P', // L - landscape, P - portrait 
                '',
                '',
                '',
                '',
                20, // margin_left
                15, // margin right
                35, // margin top
                25, // margin bottom
                0, // margin header
                0
            ); // margin footer
        }




        if ($this->mode === MpsPdf::MODE_TEMPLATE_GENERATOR) {



            $this->pdf->AddPage(
                '', // L - landscape, P - portrait
              '', '', '', '',
              6, // margin_left
              -3, // margin right
              52, // margin top
              25, // margin bottom
              0, // margin header
              2); // margin footer

        }


        

        $this->pdf->WriteHTML($html);
        return $this;
    }
}
