<?php

/**
 * Quotation related pdf generating functionalities
 */

class MpsInvoicePdf extends MpsPdf
{

    public function setMode(int $mode = 1)
    {
        $this->mode = $mode;

        return $this;
    }

    public function setModel($model)
    {
        $this->model = $model;

        return $this;
    }

    public function generate($html)
    {
        

        if (false) {

            $customer = $this->model->job->customer;
            //payment term text
        $paymentTermText = '';
        //due date setting - second scenario - based on system setting
        $systemPaymentTerm = PaymentTerm::model()->findByPk(SystemOptions::getOptions()->payment_type_id);
        if ($systemPaymentTerm) {
            $paymentTermText = $systemPaymentTerm ? ($systemPaymentTerm->days . ' ' . $systemPaymentTerm->description) : '';

            if (PaymentTerm::COD === $systemPaymentTerm->type) {
                $paymentTermText = date('d/m/Y', strtotime('now')) . ' PREPAYMENT';
            }
        }


        $masterCustomer = $customer->master;

        if ($masterCustomer) {

            $systemPaymentTerm = PaymentTerm::model()->findByPk($masterCustomer->payment_type_id);
            if ($systemPaymentTerm) {
                $paymentTermText = $systemPaymentTerm ? ($systemPaymentTerm->days . ' ' . $systemPaymentTerm->description) : '';

                if (PaymentTerm::COD === $systemPaymentTerm->type) {
                    $paymentTermText = date('d/m/Y', strtotime('now')) . ' [ PREPAYMENT ]';
                }
            }
        }

            $orderDate = date(GlobalVars::get("DateFormat"), strtotime($this->model->createdDtm));
            $invoiceNumber = $this->model->invoiceNum;
            $jobNumber = $this->model->job->jobNum;
            $poNumber = $this->model->job->customerpono;
            $dueDate = date(GlobalVars::get("DateFormat"), strtotime($this->model->job->dueDate)); // due as job due date as we already has the invocie due date in terms field
            $delivery = $this->model->job->shipSendVia;
            $salesperson = $this->model->job->salesperson ? ucwords($this->model->job->salesperson->name) : '';
            $terms = $paymentTermText;
            $extColumn = '';
            $extColumnVal = '';
    
    
            $billToAddressPlaceHolderArr = ['BILL_TO_ADDRESS_LINE_ONE' => '', 'BILL_TO_ADDRESS_LINE_TWO' => '', 'BILL_TO_ADDRESS_LINE_THREE' => '', 'BILL_TO_ADDRESS_LINE_FOUR' => '', 'BILL_TO_ADDRESS_LINE_FIVE' => '', 'BILL_TO_ADDRESS_LINE_SIX' => '', 'BILL_TO_ADDRESS_LINE_SEVEN' => '', 'BILL_TO_ADDRESS_LINE_EIGHT' => ''];
    
            $billSubStateCode = [
                $customer->cusstate,
                $customer->cuspostcode
            ];
    
            $billSubStateCode = implode(' ', $billSubStateCode);
    
            $billToAddressArr = [
                ucwords($customer->cusnam),
                ucwords($customer->cuscontact),
                $customer->cusadd1,
                $customer->cusadd2,
                $customer->cusadd3,
                $customer->custown,
                trim($billSubStateCode)
            ];
    
            $billToAddressArr = array_values(array_filter($billToAddressArr)); // remove empty values then rearrange array indexes
    
    
    
            $i = 0;
            foreach ($billToAddressPlaceHolderArr as $key => $value) {
                if (!isset($billToAddressArr[$i])) {
                    break;
                }
                $billToAddressPlaceHolderArr[$key] = $billToAddressArr[$i];
                $i++;
            }
    
            $shipToAddressPlaceHolderArr = ['SHIP_TO_ADDRESS_LINE_ONE' => '', 'SHIP_TO_ADDRESS_LINE_TWO' => '', 'SHIP_TO_ADDRESS_LINE_THREE' => '', 'SHIP_TO_ADDRESS_LINE_FOUR' => '', 'SHIP_TO_ADDRESS_LINE_FIVE' => '', 'SHIP_TO_ADDRESS_LINE_SIX' => '', 'SHIP_TO_ADDRESS_LINE_SEVEN' => ''];
    
            $shipSubStateCode = [
                $this->model->job->shipState,
                $this->model->job->shipPostalCode
            ];
    
            $shipSubStateCode = implode(' ', $shipSubStateCode);
    
            $shipToAddressArr = [
                ucwords($this->model->job->shipComanyName),
                ucwords($this->model->job->shipContactName),
                $this->model->job->shipAddress1,
                $this->model->job->shipAddress2,
                $this->model->job->shipAddress3,
                $this->model->job->shipSub,
                trim($shipSubStateCode)
            ];
    
            $shipToAddressArr = array_values(array_filter($shipToAddressArr)); // remove empty values then rearrange array indexes
    
    
    
            $j = 0;
            foreach ($shipToAddressPlaceHolderArr as $key => $value) {
                if (!isset($shipToAddressArr[$j])) {
                    break;
                }
                $shipToAddressPlaceHolderArr[$key] = $shipToAddressArr[$j];
                $j++;
            }

            $this->pdf->OverWrite(
                'images/template/INVOICE.pdf', array(
                    'ORDER_DATE',
                    'INV_NUM',
                    'DATE_TWO',
                    'JOB_NUM',
                    'PO_NUM',
                    'SALESPERSON',                    
                    'TERMS',                   
                    'BILL_TO_ADDRESS_LINE_ONE',
                    'BILL_TO_ADDRESS_LINE_TWO',
                    'BILL_TO_ADDRESS_LINE_THREE',
                    'BILL_TO_ADDRESS_LINE_FOUR',
                    'BILL_TO_ADDRESS_LINE_FIVE',
                    'BILL_TO_ADDRESS_LINE_SIX',
                    'BILL_TO_ADDRESS_LINE_SEVEN',
                    'BILL_TO_ADDRESS_LINE_EIGHT',
                    'SHIP_TO_ADDRESS_LINE_ONE',
                    'SHIP_TO_ADDRESS_LINE_TWO',
                    'SHIP_TO_ADDRESS_LINE_THREE',
                    'SHIP_TO_ADDRESS_LINE_FOUR',
                    'SHIP_TO_ADDRESS_LINE_FIVE',
                    'SHIP_TO_ADDRESS_LINE_SIX',
                    'SHIP_TO_ADDRESS_LINE_SEVEN',
                    'SHIP_TO_ADDRESS_LINE_EIGHT'
                        ), array(
                    $orderDate,
                    $invoiceNumber,
                    $orderDate,
                    $jobNumber,
                    $poNumber, 
                    $salesperson,                  
                    $terms,                  
                    $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_ONE'],
                    $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_TWO'],
                    $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_THREE'],
                    $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_FOUR'],
                    $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_FIVE'],
                    $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_SIX'],
                    $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_SEVEN'],
                    $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_EIGHT'],
                    $shipToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_ONE'],
                    $shipToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_TWO'],
                    $shipToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_THREE'],
                    $shipToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_FOUR'],
                    $shipToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_FIVE'],
                    $shipToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_SIX'],
                    $shipToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_SEVEN'],
                    $shipToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_EIGHT'],
                        ), 'F', 'images/template/INVOICE_OVERWRITE.pdf');
        }


        //rewrite the template with new header data and save
        //$mPDF1->SetImportUse();
        //set rewriten pdf file as source file
        if ($this->mode === MpsPdf::MODE_TEMPLATE_GENERATOR) {
            $pagecount = $this->pdf->SetSourceFile('images/template/INVOICE_BLANK.pdf');
        }

        if ($this->mode === MpsPdf::MODE_CONTENT_GENERATOR) {
            $pagecount = $this->pdf->SetSourceFile('images/template/blank_template.pdf');
            //$this->pdf->setFooter('{PAGENO} / {nb}');

            if($defaultPdfLogoImage = SystemOptions::getOptions()->defaultPdfLogoImage) {
                $this->pdf->SetHTMLHeader(CHtml::image("images/logos/{$defaultPdfLogoImage}", '', array()));
             }
        }

        $tplId = $this->pdf->ImportPage($pagecount);
        $this->pdf->SetPageTemplate($tplId);
        $this->pdf->shrink_tables_to_fit = 1;

        $this->pdf->defaultfooterline = false;


        $this->pdf->SetTitle('Invoice');

        if ($this->mode === MpsPdf::MODE_CONTENT_GENERATOR) {
            $this->pdf->AddPage(
                'P', // L - landscape, P - portrait
                '', '', '', '', 10, // margin_left
                10, // margin right
                35, // margin top
                25, // margin bottom
                0, // margin header
                0); // margin footer
        }




        if ($this->mode === MpsPdf::MODE_TEMPLATE_GENERATOR) {



            $this->pdf->AddPage('', // L - landscape, P - portrait
            '', '', '', '', 1, // margin_left
            3, // margin right
            55, // margin top
            25, // margin bottom
            0, // margin header
            2); // margin footer

        }


        

        $this->pdf->WriteHTML($html);
        return $this;
    }
}
