<?php
/**
 * Middle layer for pdf library
 */

 abstract class MpsPdf {
    
     const MODE_CONTENT_GENERATOR = 1; // general usage which create pdf both with tempalte and content
     const MODE_TEMPLATE_GENERATOR = 2; //use when need to generate only template file

     protected $pdf;
     protected $mode = 1;
     protected $model = null;
     protected $html = '';

     function __construct() {
        require_once 'vendor/autoload.php';
        $this->pdf = new \Mpdf\Mpdf(array(// More info: http://mpdf1.com/manual/index.php?tid=184
            'mode' => '', //  This parameter specifies the mode of the new document.
            'format' => 'A4', // format A4, A5, ...
            'default_font_size' => 0, // Sets the default document font size in points (pt)
            'default_font' => '', // Sets the default font-family for the new document.
            'mgl' => 10, // margin_left. Sets the page margins for the new document.
            'mgr' => 10, // margin_right
            'mgt' => 10, // margin_top
            'mgb' => 10, // margin_bottom
            'mgh' => 5, // margin_header
            'mgf' => 15, // margin_footer
            'orientation' => 'P', // landscape or portrait orientation
        ));
      } 

      /**
       * To generate either pdf content with template or only template 
       */
      public abstract function setMode(int $mode = 1);

      /**
       * Model class to extract data to generate html
       */
      public abstract function setModel($model);


      /**
       * Functionality to generate html
       */
      public abstract function generate($html);

      /**
       * Final out put either to save as file in local 'F' or download to browser 'I'
       */
      public function output($fileName, $type = 'I'){        
        $this->pdf->Output("{$fileName}.pdf", $type);
      }
 }