<?php

/**
 * Order Confirmation related pdf generating functionalities
 */

class MpsPurchaseOrderPdf extends MpsPdf
{

    public function setMode(int $mode = 1)
    {
        $this->mode = $mode;

        return $this;
    }

    public function setModel($model)
    {
        $this->model = $model;

        return $this;
    }

    public function generate($html)
    {
        

        if (false) {

           $orderNumber = $this->model->poNum;
           $orderDate = date(GlobalVars::get("DateFormat"), strtotime($this->model->createdDtm));
           $dueDate = Refiner::getdatetext($this->model->dueDate, GlobalVars::get("DateFormat")) ? date(GlobalVars::get("DateFormat"), strtotime($this->model->dueDate)) : 'ASAP';
           $contactName = $this->model->job->coordinator->username;
           $jobNumber = $this->model->job->jobNum;


           $billToAddressPlaceHolderArr = ['BILL_TO_ADDRESS_LINE_ONE' => '', 'BILL_TO_ADDRESS_LINE_TWO' => '', 'BILL_TO_ADDRESS_LINE_THREE' => '', 'BILL_TO_ADDRESS_LINE_FOUR' => '', 'BILL_TO_ADDRESS_LINE_FIVE' => '', 'BILL_TO_ADDRESS_LINE_SIX' => '', 'BILL_TO_ADDRESS_LINE_SEVEN' => '', 'BILL_TO_ADDRESS_LINE_EIGHT' => ''];

           $billToAddressOne = ucwords($this->model->supplier_->supnam);
           $billToAddressTwo = ucwords($this->model->supplier_->supcontact);
           $billToAddressThree = ucwords($this->model->supplier_->supad1);
           $billToAddressFour = ucwords($this->model->supplier_->supad2 . ' '. $this->model->supplier_->supad3);
           $billToAddressFive = ucwords($this->model->supplier_->suptown);
           $billToAddressSix = ucwords($this->model->supplier_->supstate . ' ' . $this->model->supplier_->suppostcode);
           $billToAddressSeven = '';
           $billToAddressEight = '';
           


           $billToAddressArr = [
               $billToAddressOne,
               $billToAddressTwo,
               $billToAddressThree,
               $billToAddressFour,
               $billToAddressFive,
               $billToAddressSix,      
               $billToAddressSeven,      
               $billToAddressEight    
           ];

           $billToAddressArr = array_values(array_filter($billToAddressArr)); // remove empty values then rearrange array indexes

           $i = 0;
           foreach ($billToAddressPlaceHolderArr as $key => $value) {
               if (!isset($billToAddressArr[$i])) {
                   break;
               }
               $billToAddressPlaceHolderArr[$key] = $billToAddressArr[$i];
               $i++;
           }



           //Delivery Addrress

           $deliveryToAddressPlaceHolderArr = ['SHIP_TO_ADDRESS_LINE_ONE' => '', 'SHIP_TO_ADDRESS_LINE_TWO' => '', 'SHIP_TO_ADDRESS_LINE_THREE' => '', 'SHIP_TO_ADDRESS_LINE_FOUR' => '', 'SHIP_TO_ADDRESS_LINE_FIVE' => '', 'SHIP_TO_ADDRESS_LINE_SIX' => '', 'SHIP_TO_ADDRESS_LINE_SEVEN' => '', 'SHIP_TO_ADDRESS_LINE_EIGHT' => ''];

           $deliveryToAddressOne = ucwords($this->model->job->shipComanyName);
           $deliveryToAddressTwo = ucwords($this->model->job->shipContactName);
           $deliveryToAddressThree = ucwords(trim($this->model->job->shipAddress1));
           $deliveryToAddressFour =  ucwords(trim($this->model->job->shipAddress2));
           $deliveryToAddressFive = ucwords(trim($this->model->job->shipAddress3 . ' ' . $this->model->job->shipSub));
           $deliveryToAddressSix = ucwords($this->model->job->shipState . ' ' . $this->model->job->shipPostalCode);
           $deliveryToAddressSeven = '';
           $deliveryToAddressEight = '';



           $deliveryToAddressArr = [
               $deliveryToAddressOne,
               $deliveryToAddressTwo,
               $deliveryToAddressThree,
               $deliveryToAddressFour,
               $deliveryToAddressFive,
               $deliveryToAddressSix,
               $deliveryToAddressSeven,
               $deliveryToAddressEight
           ];

           $deliveryToAddressArr = array_values(array_filter($deliveryToAddressArr)); // remove empty values then rearrange array indexes

           $i = 0;
           foreach ($deliveryToAddressPlaceHolderArr as $key => $value) {
               if (!isset($deliveryToAddressArr[$i])) {
                   break;
               }
               $deliveryToAddressPlaceHolderArr[$key] = $deliveryToAddressArr[$i];
               $i++;
           }


               $this->pdf->OverWrite(
                'images/template/PURCHASE_ORDER.pdf', array(
            'ORDER_NUM',
            'ORDER_DATE',
            'DUE_DATE',
            'CONTACT_NAME',
            'CODNUM',
            'BILL_TO_ADDRESS_LINE_ONE',
            'BILL_TO_ADDRESS_LINE_TWO',
            'BILL_TO_ADDRESS_LINE_THREE',
            'BILL_TO_ADDRESS_LINE_FOUR',
            'BILL_TO_ADDRESS_LINE_FIVE',
            'BILL_TO_ADDRESS_LINE_SIX',
            'BILL_TO_ADDRESS_LINE_SEVEN',
            'BILL_TO_ADDRESS_LINE_EIGHT',                
            'SHIP_TO_ADDRESS_LINE_ONE',
            'SHIP_TO_ADDRESS_LINE_TWO',
            'SHIP_TO_ADDRESS_LINE_THREE',
            'SHIP_TO_ADDRESS_LINE_FOUR',
            'SHIP_TO_ADDRESS_LINE_FIVE',
            'SHIP_TO_ADDRESS_LINE_SIX',        
            'SHIP_TO_ADDRESS_LINE_SEVEN',        
            'SHIP_TO_ADDRESS_LINE_EIGHT',                
                ), array(
            $orderNumber,
            $orderDate,
            $dueDate,
            $contactName,
            $jobNumber,
            $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_ONE'],
            $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_TWO'],
            $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_THREE'],
            $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_FOUR'],
            $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_FIVE'],
            $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_SIX'],
            $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_SEVEN'],
            $billToAddressPlaceHolderArr['BILL_TO_ADDRESS_LINE_EIGHT'],

            $deliveryToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_ONE'],
                    $deliveryToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_TWO'],
                    $deliveryToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_THREE'],
                    $deliveryToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_FOUR'],
                    $deliveryToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_FIVE'],
                    $deliveryToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_SIX'],
                    $deliveryToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_SEVEN'],
                    $deliveryToAddressPlaceHolderArr['SHIP_TO_ADDRESS_LINE_EIGHT'],
            '',
            ''
                ), 'F', 'images/template/PURCHASE_ORDER_OVERWRITE.pdf');
        }


        //rewrite the template with new header data and save
        //$mPDF1->SetImportUse();
        //set rewriten pdf file as source file
        if ($this->mode === MpsPdf::MODE_TEMPLATE_GENERATOR) {
            $pagecount = $this->pdf->SetSourceFile('images/template/PURCHASE_ORDER_BLANK.pdf');
        }

        if ($this->mode === MpsPdf::MODE_CONTENT_GENERATOR) {
            $pagecount = $this->pdf->SetSourceFile('images/template/blank_template.pdf');
            //$this->pdf->setFooter('{PAGENO} / {nb}');

            if($defaultPdfLogoImage = SystemOptions::getOptions()->defaultPdfLogoImage) {
                $this->pdf->SetHTMLHeader(CHtml::image("images/logos/{$defaultPdfLogoImage}", '', array()));
             }
        }

        $tplId = $this->pdf->ImportPage($pagecount);
        $this->pdf->SetPageTemplate($tplId);
        $this->pdf->shrink_tables_to_fit = 1;

        $this->pdf->defaultfooterline = false;


        $this->pdf->SetTitle('Order Confirmation');

        if ($this->mode === MpsPdf::MODE_CONTENT_GENERATOR) {
            $this->pdf->AddPage(
                'P', // L - landscape, P - portrait 
                '',
                '',
                '',
                '',
                10, // margin_left
                10, // margin right
                35, // margin top
                25, // margin bottom
                0, // margin header
                3
            ); // margin footer
        }


        if ($this->mode === MpsPdf::MODE_TEMPLATE_GENERATOR) {
            
            $this->pdf->AddPage(
                '', // L - landscape, P - portrait
                '',
                '',
                '',
                '',
                1, // margin_left
                3, // margin right
                50, // margin top
                25, // margin bottom
                0, // margin header
                2
            ); // margin footer

        }


        

        $this->pdf->WriteHTML($html);
        return $this;
    }
}
