<?php

/**
 * Quotation related pdf generating functionalities
 */

class MpsWorkOrderPdf extends MpsPdf
{

    public function setMode(int $mode = 1)
    {
        $this->mode = $mode;

        return $this;
    }

    public function setModel($model)
    {
        $this->model = $model;

        return $this;
    }

    public function generate($html)
    {
        $soNumber = $this->model->salesorderNumber;
        $createddate = date('d/m/Y', strtotime($this->model->createddate));

        $contact = ucwords($this->model->customer->cuscontact);
        $companyName = ucwords($this->model->customer->cusnam);
        //$email = $this->model->customer->cusemail;

        if (false) {
            $this->pdf->OverWrite(
                'images/template/QUOTATION.pdf',
                array(
                    'QUOTE_NUM',
                    'QUOTE_DATE',
                    'ATTENTION',
                    'CUSTOMER_CONTACT'                    
                ),
                array(
                    $soNumber,
                    $createddate,
                    $companyName,
                    $contact
                ),
                'F',
                'images/template/QUOTATION_OVERWRITE.pdf'
            );
        }


        //rewrite the template with new header data and save
        //$mPDF1->SetImportUse();
        //set rewriten pdf file as source file
        if ($this->mode === MpsPdf::MODE_TEMPLATE_GENERATOR) {
            $pagecount = $this->pdf->SetSourceFile('images/template/QUOTATION_BLANK.pdf');
        }

        if ($this->mode === MpsPdf::MODE_CONTENT_GENERATOR) {

            $pagecount = $this->pdf->SetSourceFile('images/template/blank_template.pdf');

             //code to generate header until get the PDF template from the client
             if($defaultPdfLogoImage = SystemOptions::getOptions()->defaultPdfLogoImage) {
                $this->pdf->SetHTMLHeader(CHtml::image("images/logos/{$defaultPdfLogoImage}", '', array()));
             }
             
             
            
            //$this->pdf->setFooter('{PAGENO} / {nb}');

           

        }

        $tplId = $this->pdf->ImportPage($pagecount);
        $this->pdf->SetPageTemplate($tplId);
        $this->pdf->shrink_tables_to_fit = 1;

        $this->pdf->defaultfooterline = false;


        $this->pdf->SetTitle('Quotation');

        if ($this->mode === MpsPdf::MODE_CONTENT_GENERATOR) {
            $this->pdf->AddPage(
                'P', // L - landscape, P - portrait 
                '',
                '',
                '',
                '',
                10, // margin_left
                10, // margin right
                35, // margin top
                25, // margin bottom
                0, // margin header
                3
            ); // margin footer
        }




        if ($this->mode === MpsPdf::MODE_TEMPLATE_GENERATOR) {



            $this->pdf->AddPage(
                '', // L - landscape, P - portrait
                '',
                '',
                '',
                '',
                1, // margin_left
                3, // margin right
                55, // margin top
                25, // margin bottom
                0, // margin header
                2
            ); // margin footer

        }


        

        $this->pdf->WriteHTML($html);
        return $this;
    }
}
