<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of PDFCreator
 *
 * @author User
 */
abstract class PDFCreator
{
	protected $config = array(
		'title' => '',
		'content' => '<h1>PDF Content!</h1>',
		'pageNumber' => '{PAGENO}',
		'outputFileName' => '',
		'outputFileType' => 'I'
	);
	
	/**
	 * Factory method - this shows how the generator class should be used
	 * you can override this function to set more options
	 * PDFCreator has used factory pattern
	 * If you need to dynamically change the template type of the PDF (PDFGenerator) do it by implementing from this class
	 * @return stream output stream
	 */
	public function generate()
	{
		$pdfView = $this->getPDFView();
		$pdfView->setTitle($this->config['title'])
				->writeContent($this->config['content'])
				->setPageNumber($this->config['pageNumber'])
				->setOutputFileName($this->config['outputFileName']?: time() . 'pdf')
				->setOutputFileType($this->config['outputFileType']??'I')
				->generate();
	}
	
	/**
	 * override this function to change the template of your PDF
	 * PDFGenerator has used builder pattern to create PDF templates
	 * if you need to modify the pdf library options or modify pdf library setting do it in PDFGenerator subclasses
	 * @return PDFGenerator 
	 */
	public abstract function getPDFView() : PDFGenerator;
}
