<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * PlainPDFGenerator is base class for to generate PDFs, if your PDFs need more modification extent from this class and override the functionality
 *
 * @author rajaera@gmail.com
 */
class PlainPDFGenerator implements PDFGenerator
{

	
	protected $pdfLibraryConfig = array(// More info: http://mpdf1.com/manual/index.php?tid=184
		'mode' => '', //  This parameter specifies the mode of the new document.
		'format' => 'A4', // format A4, A5, ...
		'default_font_size' => 0, // Sets the default document font size in points (pt)
		'default_font' => '', // Sets the default font-family for the new document.
		'mgl' => 10, // margin_left. Sets the page margins for the new document.
		'mgr' => 10, // margin_right
		'mgt' => 10, // margin_top
		'mgb' => 10, // margin_bottom
		'mgh' => 5, // margin_header
		'mgf' => 15, // margin_footer
		'orientation' => 'P', // landscape or portrait orientation
	);
	protected $HTMLHeader;
	protected $templateFileName = '';
	protected $pageConfig = array(
		'orientation' => 'P', // L - landscape, P - portrait 
		'condition' => '',
		'resetpagenum' => '',
		'pagenumstyle' => '',
		'suppress' => '',
		'mgl' => 5,
		'mgr' => 5,
		'mgt' => 10,
		'mgb' => 25,
		'mgh' => 0,
		'mgf' => 0,
	);
	protected $pdfTitleName;
	protected $htmlContent;
	protected $pdfFooter = '';
	protected $defaultfooterline;
	protected $pageNumberFormat = '';	
	protected $outputFileName;
	protected $outputFileType;

	/**
	 * PDf template file to set as background 
	 * @param string $fileName
	 * @return PDFGenerator
	 */
	public function SetTemplateFile(string $fileName): \PDFGenerator
	{
		$this->templateFileName = $fileName;
		return $this;
	}
	

	/**
	 * PDf library main configurations 
	 * @param array $config
	 * @return PDFGenerator
	 */
	public function setLibraryConfig(array $config): \PDFGenerator
	{
		$this->pdfLibraryConfig = $config;
		return $this;
	}

	/**
	 * PDf output file name default to time()
	 * @param string $fileName
	 * @return PDFGenerator
	 */
	public function setOutputFileName(string $fileName): \PDFGenerator
	{
		$this->outputFileName = $fileName;
		return $this;
	}
	
	/**
	 * Output type I | F - output stream or save local
	 * @param string $fileType
	 * @return PDFGenerator
	 */
	public function setOutputFileType(string $fileType): \PDFGenerator
	{
		$this->outputFileType = $fileType;
		return $this;
	}

	/**
	 * PDf configuration for the PDF page
	 * @param array $config
	 * @return PDFGenerator
	 */
	public function setPageConfig(array $config): \PDFGenerator
	{
		$this->pageConfig = $config;
		return $this;
	}

	/**
	 * PDf content as HTML or Texts
	 * @param string $contentText
	 * @return PDFGenerator
	 */
	public function writeContent(string $contentText): \PDFGenerator
	{
		$this->htmlContent = $contentText;
		return $this;
	}

	/**
	 * PDf set page number by format
	 * @param string $format
	 * @return PDFGenerator
	 */
	public function setPageNumber(string $format): \PDFGenerator
	{
		$this->pageNumberFormat = $format;
		return $this;
	}

	/**
	 * PDf title to show in web browser tab
	 * @param string $titleName
	 * @return PDFGenerator
	 */
	public function setTitle(string $titleName): \PDFGenerator
	{
		$this->pdfTitleName = $titleName;
		return $this;
	}

	/**
	 * PDf footer HTML or Text
	 * @param string $footer 
	 * @return PDFGenerator
	 */
	public function setFooter(string $footer): \PDFGenerator
	{
		$this->pdfFooter = $footer;
		return $this;
	}

	/**
	 * PDf build by assembling all the necessary parts
	 * 
	 * @return stream
	 */
	public function generate()
	{
		require_once 'vendor/autoload.php';
		$mpdf = new \Mpdf\Mpdf($this->pdfLibraryConfig);
		$mpdf->SetTitle($this->pdfTitleName);

		if ($this->templateFileName) {
			$template = $mpdf->SetSourceFile($this->templateFileName);
			$tplId = $mpdf->ImportPage($template);
			$mpdf->SetPageTemplate($tplId);
		}

		$mpdf->AddPage(
				$this->pageConfig['orientation'], 
				$this->pageConfig['condition'], 
				$this->pageConfig['resetpagenum'], 
				$this->pageConfig['pagenumstyle'], 
				$this->pageConfig['suppress'], 
				$this->pageConfig['mgl'], 
				$this->pageConfig['mgr'], 
				$this->pageConfig['mgt'], 
				$this->pageConfig['mgb'], 
				$this->pageConfig['mgh'], 
				$this->pageConfig['mgf']
		);

		$mpdf->WriteHTML($this->htmlContent);

		if ($this->pdfFooter || $this->pageNumberFormat) {
			$mpdf->setFooter($this->pdfFooter . $this->pageNumberFormat);
		}

		

		$mpdf->Output(($this->outputFileName ?? time()), $this->outputFileType);
	}

	

}
