<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of WebServiceQuoteBuilder
 *
 * @author Eranga
 */
class WebServiceQuoteBuilder implements WebServiceBuilder {

    protected $quote;
    protected $quoteDetails = array();
    protected $quoteDecorations = array();
    protected $errors = array();

    //put your code here
    public function build(array $data) {
        if ($this->validate($data)) {
            $transaction = Yii::app()->db->beginTransaction();
            try {
                $this->createQuote($data)
                        ->addDetails($data);
            } catch (Exception $ex) {

                $this->errors['Message'] = $ex->getMessage();
                $this->errors['File'] = $ex->getFile();
                $this->errors['Line'] = $ex->getLine();
                $transaction->rollback();
                return false;
            }

            $transaction->commit();
            return true;
        } else {
            $this->errors['Message'] = "Validation Error due to missing one of QuotationNumber, Products";
            return false;
        }
    }

    protected function validate(array $data) {
        //if (!isset($data['QuotationNumber'], $data['Products'], $data['Customer'], $data['Salesperson'])) {
        if (!isset($data['QuotationNumber'], $data['Products'])) {
            return false;
        }

        if (!trim($data['QuotationNumber'])) {
            return false;
        }
        return true;
    }

    protected function createQuote(array $data) {

        $webservice = WebService::model()->find(
                array(
                    'condition' => "ws_date =:ws_date AND ws_time=:ws_time",
                    'params' => array(
                        ':ws_date' => date('Y-m-d', strtotime($data['Date'])),
                        ':ws_time' => date('H:i:s', strtotime($data['Date']))
        )));

        $quoteno = '' . $data['QuotationNumber'];

        if ($quoteExist = Quatation::model()->find(array('condition' => "ws_quoteno = '{$data['QuotationNumber']}'", 'order' => 'id DESC'))) {


            if (!$soCreadted = Workorder::model()->find("quotationId = {$quoteExist->id}")) {


                $duplicateCount = count(Quatation::model()->findAll(array('condition' => "ws_quoteno = '{$data['QuotationNumber']}'")));
                if ($duplicateCount > 1) {
                    //if there are more than one quote and current quote has no SO, still need to create newer version of the quote
                    $quoteno = $data['QuotationNumber'] . '-V' . ($duplicateCount + 1);
                    $this->quote = new Quatation();
                } else {
                    //if ther is only one quote without SO then update that one
                    $this->quote = $quoteExist;
                    //drop the exisiting quote DETAILS to recreate with new data 
                    $deleted = QuoteProductDecoration::model()->deleteAll(array('condition' => "quoteid = {$quoteExist->id}"));
                    $deleted = QuatationDetails::model()->deleteAll(array('condition' => "quoteid = {$quoteExist->id}"));
                }
            } else {
                //if existed quote has SO then must need to create new one instead update the existing one
                $duplicateCount = count(Quatation::model()->findAll(array('condition' => "ws_quoteno = '{$data['QuotationNumber']}'")));
                if ($duplicateCount) {
                    $quoteno = $data['QuotationNumber'] . '-V' . ($duplicateCount + 1);
                    $this->quote = new Quatation();
                }
            }
        } else {
            //if quote not exist this will be a new quote
            $this->quote = new Quatation();
        }


        $this->quote->ws_id = $webservice->ws_id;
        $this->quote->quoteno = $quoteno; // local system specific quote number
        $this->quote->ws_quoteno = $data['QuotationNumber']; //original quote number
        $this->quote->quotename = $data['QuotationName'];
        $this->quote->quotecomments = $data['Comment'];
        $this->quote->dueDate = date('Y-m-d H:i:s', strtotime($data['DueDate']));

        $this->quote->cus_fref = $data['Customer']['Reference'];
        $this->quote->quotecreatedby = Yii::app()->user->id;
        $this->quote->quotecreated = date("Y-m-d H:i:s"); // current date & time
        $this->quote->ws_date = date('Y-m-d H:i:s', strtotime("{$webservice->ws_date} {$webservice->ws_time}"));
        $this->quote->ws_user = $webservice->ws_user;
        $this->quote->status = Quatation::STATUS_NEW;





        $salesperson = SalesPerson::updateSalesperson(array(
                    'log_id' => $data['Salesperson']['LogId'],
                    'name' => $data['Salesperson']['Name'],
                    'email' => $data['Salesperson']['Email'],
                    'phone_direct_line' => $data['Salesperson']['DirectLine'],
                    'phone_mobile' => $data['Salesperson']['Mobile'],
        ));




        if (!$salesperson) {
            throw new Exception;
        }


        $this->quote->ws_user_id = $salesperson->id;
        $this->quote->salesperson_id = $salesperson->id;

        if ($this->quote->save(false)) {

            if (isset(SystemOptions::getOptions()->defaultJobFollouUpStatusId) && (int) SystemOptions::getOptions()->defaultJobFollouUpStatusId) {
                //create CRM for follow-up status and date
                $salesLog = new SalesLog();
                $salesLog->quoteId = $this->quote->id;
                $salesLog->quoteNum = $this->quote->quoteno;
                $salesLog->category = 'Quotation';


                $salesLog->tbl_id = $this->quote->id;
                $salesLog->followupSts_id = (int) SystemOptions::getOptions()->defaultJobFollouUpStatusId;
                $salesLog->followupDtm = date('Y-m-d H:i:s', strtotime($data['DueDate']));
                $salesLog->save(false);
            }


            //web service data must be updated as read otherwise same data will be selected
            WebService::model()->updateAll(array('is_read' => 1), "ws_date = '{$webservice->ws_date}' AND ws_time = '{$webservice->ws_time}'");

            $url = Yii::app()->createUrl('quotation/quoteResolver', array("quoteno" => $this->quote->quoteno));
            $link = CHtml::link($this->quote->quoteno, $url, array('target' => '_blank'));

            $createdBy = Yii::app()->user->id;
            if ($salesperson->user_id) {
                $createdBy = $salesperson->user_id;
            }

            SalesLog::createSalesLogByAtrributes(array(
                'quoteId' => $this->quote->id,
                'workorderId' => null,
                'quoteNum' => $this->quote->quoteno,
                'category' => 'Quotation',
                'comments' => "Quotation [{$link}] has been processed from the web service quote on {$webservice->ws_date} {$webservice->ws_time}",
                'isIntrnl' => 0,
                'isExtrnl' => 0,
                'isTechnical' => 0,
                'createdBy' => $createdBy
            ));

            return $this;
        } else {
            throw new Exception;
        }
    }

    protected function addDetails(array $data) {
        foreach ($data['Products'] as $prodWsId => $productDataArr) {
            $productDetail = new QuatationDetails();
            $productDetail->quoteid = $this->quote->id;
            $productDetail->ws_id = $prodWsId;
            $productDetail->productsku = $productDataArr['Code'];
            $productDetail->qty = $productDataArr['Quantity'];
            $productDetail->productexunitprice = $productDataArr['UnitPrice'];
            $productDetail->productname = $productDataArr['Name'];
            $productDetail->sup_fref = $productDataArr['Supplier']['Reference'];
            $productDetail->supmarg = $productDataArr['Supplier']['Margin'];
            $productDetail->customerdicspcn = $productDataArr['CusomerDiiscountPercentage'];
            $productDetail->productimg = $productDataArr['PhtoURI'];
            $productDetail->productdescription = $productDataArr['Description'];
            $productDetail->prodctfrieght = $productDataArr['Freight'];
            $productDetail->productvat = $productDataArr['Tax'];
            $productDetail->supname = $productDataArr['Supplier']['Name'];
            $productDetail->sellunitprice_ex_vat = $productDataArr['SellPriceExcludingTax'];
            $productDetail->sellunitprice_in_vat = $productDataArr['SellPriceIncludingTax'];
            $productDetail->selltot_ex_vat = $productDataArr['SellTotalExcludingTax'];
            $productDetail->selltot_in_vat = $productDataArr['SellTotalIncludingTax'];
            $productDetail->lockSellPrice = SystemOptions::getOptions()->quoteLockSellPrice ?: 0;

            $usdUnitMarkupRate = $productDataArr['FreightMarkUp'] ? ((floatval($productDataArr['FreightMarkUp']) + 100) / 100) : 0;

            $productDetail->productFrieghtMarkUpRate = $usdUnitMarkupRate;
            $productDetail->productFrieghtUnitCost = $productDataArr['USDFreight'];
            $productDetail->productFrieghtUnitCostWithMarkup = $productDataArr['FreightUnitMarkedUpCost'];

            $productDetail->customNote = $productDataArr['CustomNote']; /* 2021-08-29 */

            if ($productDetail->save(false)) {

                //update overall prices of the quote;
                $productDetail->quotePriceUpdate();

                $productDetail->saveImageContent($productDetail->productimg);
                $product = ProductLine::updateProductLine(array(
                            'pdlpdl' => $productDetail->productsku,
                            'supsup_fref' => $productDetail->sup_fref,
                            'pdlprdline' => $productDetail->productname,
                            'pdldes' => $productDetail->productdescription,
                            'pdluntprice' => $productDetail->productexunitprice,
                            'usdUnitFreightCost' => $productDetail->productFrieghtUnitCost,
                            'usdUnitFreightMarkupRate' => $productDetail->productFrieghtMarkUpRate,
                            'pdlsupmargin' => $productDetail->supmarg
                ));                

                $this->quoteDetails[] = $productDetail;

                if (isset($productDataArr['Decorations'])) {
                    foreach ($productDataArr['Decorations'] as $decoWsId => $decoArr) {
                        $decoration = new QuoteProductDecoration();
                        $decoration->ws_id = $decoWsId;
                        $decoration->quoteid = $this->quote->id;
                        $decoration->productsku = $productDetail->productsku;
                        $decoration->quataiondetailsid = $productDetail->id;
                        $decoration->decprtnam = $decoArr['Code'];
                        $decoration->decorationdescription = $decoArr['Description'];
                        $decoration->decorationqty = $decoArr['Quantity'];
                        $decoration->decorationunitval = $decoArr['UnitPrice'];
                        $decoration->logosetupcharge = $decoArr['LogoSetupCharge'];
                        $decoration->customerdicspcn = $decoArr['CusomerDiiscountPercentage'];
                        $decoration->maindecorationid = $decoArr['MasterCode'];
                        $decoration->decorationfreightval = $decoArr['Freight'];
                        $decoration->decorationvat = $decoArr['Tax'];
                        $decoration->supref = $decoArr['Supplier']['Reference'];
                        $decoration->supmarg = $decoArr['Supplier']['Margin'];


                        $decoration->logoSetupMarkupRate = $decoArr['LogoSetupUnitMarkUpRate'];
                        $decoration->logoSetupUnitCost = $decoArr['LogoSetupUnitCost'];
                        $decoration->logoSetupUnitCostWithMarkup = $decoArr['LogoSetupUnitMarkedUpPrice'];

                        if ($decoration->save(false)) {

                            if ($decoArr['MasterCode'] && !in_array($decoArr['MasterCode'], array('N/A'))) {
                                $masterDeco = Decoration::updateDecoration(array(
                                            'supsup_fref' => null,
                                            'decprtnam' => $decoArr['MasterCode'],
                                            'deccustomyn' => 'N',
                                            'decnam' => $decoArr['MasterCode'],
                                            'declogo_setup_charges' => 0,
                                            'logoSetupUnitMarkupRate' => 0,
                                            'decuntprice' => 0,
                                            'decmaintypsno' => 0,
                                            'decis_main_type' => 'Y',
                                            'decis_shown_to_clients' => 1,
                                            'decflag' => 1,
                                ));

                                if ($masterDeco) {
                                    $decoModel = Decoration::updateDecoration(array(
                                                'supsup_fref' => $decoration->supref,
                                                'decprtnam' => $decoration->decprtnam,
                                                'deccustomyn' => 'N',
                                                'decnam' => $decoration->decorationdescription,
                                                'declogo_setup_charges' => $decoration->logosetupcharge,
                                                'logoSetupUnitMarkupRate' => $decoration->logoSetupMarkupRate,
                                                'decuntprice' => $decoration->decorationunitval,
                                                'decmaintypsno' => $masterDeco->decsno,
                                                'decis_main_type' => 'N',
                                                'decis_shown_to_clients' => 1,
                                                'decflag' => 1,
                                    ));
                                    
                                }
                            }

                            $this->quoteDecorations[] = $decoration;
                        } else {
                            throw new Exception;
                        }
                    }
                }
            } else {
                throw new Exception;
            }
        }

        return $this;
    }

    public function getErrors() {
        return $this->errors;
    }

    public function getQuotation() {
        return $this->quote;
    }

}
