<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of WebServiceQuoteBuilderClient
 *
 * @author Eranga
 */
class WebServiceQuoteBuilderClient {
    
    protected $processQuotesPerTime = 3;
    protected $messages = [];
    

    public function processQuotations() {
        // inject the finding logic to the web service as finder
        $webserviceData = WebService::findQuotes(new WebServiceQuoteTimestampFinder());
        
        foreach ($webserviceData as $model) {

            $quoteBuilder = new WebServiceQuoteBuilder();

            if (!$quoteBuilder->build($model->toArray())) {
                $errors = $quoteBuilder->getErrors();
                $this->messages[] = "Quote [{$model->ws_quoteno}] skipped : " . $errors['Message'];
            }
        }
    }
    
    public function setProcessQuotesPerTime($quoteCount) {
        $this->processQuotesPerTime = $quoteCount;
    }
    
    public function getMessages() {
        return array_filter($this->messages);
    }

}
