<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of WebServiceQuoteBuilder
 *
 * @author Eranga
 */
class WebServiceQuoteUpdater implements WebServiceBuilder {

    protected $quote;
    protected $quoteDetails = array();
    protected $quoteDecorations = array();
    protected $errors = array();

    //put your code here
    public function build(array $data) {
        if ($this->validate($data)) {
            $transaction = Yii::app()->db->beginTransaction();
            try {
                $this->updateQuote($data)
                        ->addDetails($data);
            } catch (Exception $ex) {
                $this->errors['Message'] = $ex->getMessage();
                $this->errors['File'] = $ex->getFile();
                $this->errors['Line'] = $ex->getLine();
                $transaction->rollback();
                print_r($ex);
                exit();
                return false;
            }

            $transaction->commit();
            return true;
        } else {
            $this->errors['Validation'] = "Validation Error due to missing one of QuotationNumber, Products, Customer, Salesperson";
            return false;
        }
    }

    protected function validate(array $data) {
        if (!isset($data['QuotationNumber'], $data['Products'], $data['Customer'], $data['Salesperson'])) {
            return false;
        }

        if (!trim($data['QuotationNumber'])) {
            return false;
        }
        return true;
    }

    protected function updateQuote(array $data) {

        $webservice = WebService::model()->find(
                array(
                    'condition' => "ws_date =:ws_date AND ws_time=:ws_time",
                    'params' => array(
                        ':ws_date' => date('Y-m-d', strtotime($data['Date'])),
                        ':ws_time' => date('H:i:s', strtotime($data['Date']))
        )));

        

       




        $this->quote = Quatation::model()->find(array('condition' => "ws_date = '{$webservice->ws_date} {$webservice->ws_time}'"));
        $this->quote->ws_id = $webservice->ws_id;        
        $this->quote->quotename = $data['QuotationName'];
        $this->quote->quotecomments = $data['Comment'];
        $this->quote->dueDate = date('Y-m-d H:i:s', strtotime($data['DueDate']));

        $this->quote->cus_fref = $data['Customer']['Reference'];
        

        $salesperson = SalesPerson::updateSalesperson(array(
                    'log_id' => $data['Salesperson']['LogId'],
                    'name' => $data['Salesperson']['Name'],
                    'email' => $data['Salesperson']['Email'],
                    'phone_direct_line' => $data['Salesperson']['DirectLine'],
                    'phone_mobile' => $data['Salesperson']['Mobile'],
        ));


        

        if (!$salesperson) {           
            throw new Exception;
        }       
         

        $this->quote->ws_user_id = $salesperson->id;
        $this->quote->salesperson_id = $salesperson->id;

        if ($this->quote->save(false)) {
           
             $deleted = QuoteProductDecoration::model()->deleteAll(array('condition' => "quoteid = {$this->quote->id}"));
             $deleted = QuatationDetails::model()->deleteAll(array('condition' => "quoteid = {$this->quote->id}"));
            
            SalesLog::createSalesLog($this->quote->id, null, $this->quote->quoteno, 'Quotation', 'Quotation has been updated from the web service', 0, 0, 1);
            return $this;
        } else {
            throw new Exception;
        }
    }

    protected function addDetails(array $data) {
        foreach ($data['Products'] as $prodWsId => $productDataArr) {
            $productDetail = new QuatationDetails();
            $productDetail->quoteid = $this->quote->id;
            $productDetail->ws_id = $prodWsId;
            $productDetail->productsku = $productDataArr['Code'];
            $productDetail->qty = $productDataArr['Quantity'];
            $productDetail->productexunitprice = $productDataArr['UnitPrice'];
            $productDetail->productname = $productDataArr['Name'];
            $productDetail->sup_fref = $productDataArr['Supplier']['Reference'];
            $productDetail->supmarg = $productDataArr['Supplier']['Margin'];
            $productDetail->customerdicspcn = $productDataArr['CusomerDiiscountPercentage'];
            $productDetail->productimg = $productDataArr['PhtoURI'];
            $productDetail->productdescription = $productDataArr['Description'];
            $productDetail->prodctfrieght = $productDataArr['Freight'];
            $productDetail->productvat = $productDataArr['Tax'];
            $productDetail->supname = $productDataArr['Supplier']['Name'];
            $productDetail->sellunitprice_ex_vat = $productDataArr['SellPriceExcludingTax'];
            $productDetail->sellunitprice_in_vat = $productDataArr['SellPriceIncludingTax'];
            $productDetail->selltot_ex_vat = $productDataArr['SellTotalExcludingTax'];
            $productDetail->selltot_in_vat = $productDataArr['SellTotalIncludingTax'];

            $usdUnitMarkupRate = $productDataArr['FreightMarkUp'] ? ((floatval($productDataArr['FreightMarkUp']) + 100) / 100) : 0;

            $productDetail->productFrieghtMarkUpRate = $usdUnitMarkupRate;
            $productDetail->productFrieghtUnitCost = $productDataArr['USDFreight'];
            $productDetail->productFrieghtUnitCostWithMarkup = $productDataArr['FreightUnitMarkedUpCost'];

            if ($productDetail->save(false)) {

                $productDetail->saveImageContent($productDetail->productimg);
                $product = ProductLine::updateProductLine(array(
                            'pdlpdl' => $productDetail->productsku,
                            'supsup_fref' => $productDetail->sup_fref,
                            'pdlprdline' => $productDetail->productname,
                            'pdldes' => $productDetail->productdescription,
                            'pdluntprice' => $productDetail->productexunitprice,
                            'usdUnitFreightCost' => $productDetail->productFrieghtUnitCost,
                            'usdUnitFreightMarkupRate' => $productDetail->productFrieghtMarkUpRate,
                            'pdlsupmargin' => $productDetail->supmarg
                ));

                if (!$product) {
                    throw new Exception;
                }

                $this->quoteDetails[] = $productDetail;

                if (isset($productDataArr['Decorations'])) {
                    foreach ($productDataArr['Decorations'] as $decoWsId => $decoArr) {
                        $decoration = new QuoteProductDecoration();
                        $decoration->ws_id = $decoWsId;
                        $decoration->quoteid = $this->quote->id;
                        $decoration->productsku = $productDetail->productsku;
                        $decoration->quataiondetailsid = $productDetail->id;
                        $decoration->decprtnam = $decoArr['Code'];
                        $decoration->decorationdescription = $decoArr['Description'];
                        $decoration->decorationqty = $decoArr['Quantity'];
                        $decoration->decorationunitval = $decoArr['UnitPrice'];
                        $decoration->logosetupcharge = $decoArr['LogoSetupCharge'];
                        $decoration->customerdicspcn = $decoArr['CusomerDiiscountPercentage'];
                        $decoration->maindecorationid = $decoArr['MasterCode'];
                        $decoration->decorationfreightval = $decoArr['Freight'];
                        $decoration->decorationvat = $decoArr['Tax'];
                        $decoration->supref = $decoArr['Supplier']['Reference'];
                        $decoration->supmarg = $decoArr['Supplier']['Margin'];

                        $logoSetupUnitMarkupRate = $decoArr['LogoSetupUnitMarkUp'] ? ((floatval($decoArr['LogoSetupUnitMarkUp']) + 100) / 100) : 0;
                        $decoration->logoSetupMarkupRate = $logoSetupUnitMarkupRate;
                        $decoration->logoSetupUnitCost = $decoArr['LogoSetupUnitCost'];
                        $decoration->logoSetupUnitCostWithMarkup = $decoArr['LogoSetupUnitMarkedUpPrice'];

                        if ($decoration->save(false)) {

                            if ($decoArr['MasterCode'] && !in_array($decoArr['MasterCode'], array('N/A'))) {
                                $masterDeco = Decoration::updateDecoration(array(
                                            'supsup_fref' => null,
                                            'decprtnam' => $decoArr['MasterCode'],
                                            'deccustomyn' => 'N',
                                            'decnam' => $decoArr['MasterCode'],
                                            'declogo_setup_charges' => 0,
                                            'logoSetupUnitMarkupRate' => 0,
                                            'decuntprice' => 0,
                                            'decmaintypsno' => 0,
                                            'decis_main_type' => 'Y',
                                            'decis_shown_to_clients' => 1,
                                            'decflag' => 1,
                                ));

                                if ($masterDeco) {
                                    $decoModel = Decoration::updateDecoration(array(
                                                'supsup_fref' => $decoration->supref,
                                                'decprtnam' => $decoration->decprtnam,
                                                'deccustomyn' => 'N',
                                                'decnam' => $decoration->decorationdescription,
                                                'declogo_setup_charges' => $decoration->logosetupcharge,
                                                'logoSetupUnitMarkupRate' => $decoration->logoSetupMarkupRate,
                                                'decuntprice' => $decoration->decorationunitval,
                                                'decmaintypsno' => $masterDeco->decsno,
                                                'decis_main_type' => 'N',
                                                'decis_shown_to_clients' => 1,
                                                'decflag' => 1,
                                    ));

                                    if (!$decoModel) {
                                        throw new Exception;
                                    }
                                }
                            }

                            $this->quoteDecorations[] = $decoration;
                        } else {
                            throw new Exception;
                        }
                    }
                }
            } else {
                throw new Exception;
            }
        }

        return $this;
    }

    public function getErrors() {
        return $this->errors;
    }

}
