<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');
// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(
    'basePath' => dirname(__FILE__) . DIRECTORY_SEPARATOR . '..',
    'name' => 'PP and U',
    // preloading 'log' component
    'preload' => array('log', 'bootstrap'),
    // autoloading model and component classes
    'import' => array(
        'application.models.*',
        'application.components.*',
        'application.components.classes.*',
        'application.components.pdf.*',
        'application.components.order.*',
        'application.modules.rights.components.*',
         'application.components.webservice.*',
        'application.mps_helpers.pdf.*',
    ),
    'modules' => array(
        'rights' => array(
            'superuserName' => 'SuperAdmin', // Name of the role with super user privileges.
            //'authenticatedName'=>'Authenticated', // Name of the authenticated user role.
            //'userIdColumn'=>'id', // Name of the user id column in the database.
            //'userNameColumn'=>'username', // Name of the user name column in the database.
            'enableBizRule' => false, // Whether to enable authorization item business rules.
            //'enableBizRuleData'=>false, // Whether to enable data for business rules.
            //'displayDescription'=>true, // Whether to use item description instead of name.
            //'flashSuccessKey'=>'RightsSuccess', // Key to use for setting success flash messages.
            //'flashErrorKey'=>'RightsError', // Key to use for setting error flash messages.
            'baseUrl' => '/rights', // Base URL for Rights. Change if module is nested.
            //'layout'=>'rights.views.layouts.main', // Layout to use for displaying Rights.
            //'appLayout'=>'webroot.themes.admin.views.layouts.main', // Application layout.
            //'cssFile'=>'rights.css', // Style sheet file to use for Rights.
            'install' => false, // Whether to enable installer.
            //'debug'=>false, // Whether
            //===Below rights configurations are added for new customizations==
            // Amoung many super users, some permissions are granted only for
            // superuser with id 0(user table id 0),
            'superuserId' => 23,
            'adminRoleName' => 'Administrator',
        ),
        // uncomment the following to enable the Gii tool
        'gii' => array(
            'class' => 'system.gii.GiiModule',
            'password' => '123',
            // If removed, Gii defaults to localhost only. Edit carefully to taste.
            'ipFilters' => array('127.0.0.1', '::1'),
        ),
    ),
    'homeUrl' => array('jobs/jobflow'),
    //'homeUrl' => array('quatation/processQuotations'),
    // application components
    'components' => array(
        'ePdf' => array(
            'class' => 'ext.yii-pdf.EYiiPdf',
            'params' => array(
                'mpdf' => array(
                    'librarySourcePath' => 'application.vendors.mpdf.*',
                    'constants' => array(
                        '_MPDF_TEMP_PATH' => Yii::getPathOfAlias('application.runtime'),
                    ),
                    'class' => 'mpdf', // the literal class filename to be loaded from the vendors folder
                    'defaultParams' => array(// More info: http://mpdf1.com/manual/index.php?tid=184
                        'mode' => '', //  This parameter specifies the mode of the new document.
                        'format' => 'A4', // format A4, A5, ...
                        'default_font_size' => 0, // Sets the default document font size in points (pt)
                        'default_font' => '', // Sets the default font-family for the new document.
                        'mgl' => 10, // margin_left. Sets the page margins for the new document.
                        'mgr' => 10, // margin_right
                        'mgt' => 27, // margin_top
                        'mgb' => 10, // margin_bottom
                        'mgh' => 5, // margin_header
                        'mgf' => 15, // margin_footer
                        'orientation' => 'P', // landscape or portrait orientation
                    )
                ),
            ),
        ),
        'bootstrap' => array(
            'class' => 'ext.bootstrap.components.Bootstrap',
        ),
        'user' => array(
            // enable cookie-based authentication
            'allowAutoLogin' => true,
            'class' => 'RWebUser',
        ),
        'MultiMailer' => array(
            'class' => 'ext.MultiMailer.MultiMailer',
            //'setFromAddress' => 'admin@mypromosource.com',
            'setFromName' => 'New Promo Office',
        ),
        // uncomment the following to enable URLs in path-format
        /*
          'urlManager'=>array(
          'urlFormat'=>'path',
          'rules'=>array(
          '<controller:\w+>/<id:\d+>'=>'<controller>/view',
          '<controller:\w+>/<action:\w+>/<id:\d+>'=>'<controller>/<action>',
          '<controller:\w+>/<action:\w+>'=>'<controller>/<action>',
          ),
          ),
         */
//        'db' => array(
//            'connectionString' => 'sqlite:' . dirname(__FILE__) . '/../data/testdrive.db',
//        ),
        // uncomment the following to use a MySQL database
        'db' => array(
            'connectionString' => 'mysql:host=localhost;dbname=jobsppanducom_promo',
            'emulatePrepare' => true,
            'username' => 'jobsppanducom_admin',
            'password' => 'kJ5gAC)kD5kJ',
            'charset' => 'utf8',
        ),
        'authManager' => array('class' => 'RDbAuthManager'),
        'errorHandler' => array(
        // use 'site/error' action to display errors
        //'errorAction' => 'site/error',
        ),
        'log' => array(
            'class' => 'CLogRouter',
            'routes' => array(
                array(
                    'class' => 'CFileLogRoute',
                    'levels' => 'error, warning, trace, info',
                    'categories' => 'system.*',
                ),
                array(
                    'class' => 'CEmailLogRoute',
                    'levels' => 'error, warning',
                    'emails' => 'rajaera@gmail.com',
                ),
            // uncomment the following to show log messages on web pages
            /*
              array(
              'class'=>'CWebLogRoute',
              ),
             */
            ),
        ),
        'image' => array(
            'class' => 'application.extensions.image.CImageComponent',
            'driver' => 'GD',
        ),
    ),
    // application-level parameters that can be accessed
    // using Yii::app()->params['paramName']
    'params' => array(
        // this is used in contact page
        'adminEmail' => '',
        'companyName' => 'gun web systems',
        'logo' => array(
            'name' => 'main_logo.jpg',
            'width' => 429,
            'height' => 94
        ),
    ),
);
